package gov.va.med.esr.service;


import gov.va.med.esr.common.model.ee.IRS1095B;
import gov.va.med.esr.common.model.messaging.IrsTransmissionLogData;
import gov.va.med.esr.common.model.messaging.IrsTransmissionLogEntry;
import gov.va.med.fw.service.ServiceException;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
public interface IRSWebServiceDelegate extends Serializable{


	 public String transmitOriginal(IrsTransmissionLogEntry transmission) throws ServiceException;

	 public String retransmitBatchSubmission(IrsTransmissionLogEntry transmission, String originalReceipt) throws ServiceException;

	 public String retransmitPersonSubmission(IrsTransmissionLogEntry transmission, String originalReceipt) throws ServiceException;

	 public void requestProcessingStatus(IrsTransmissionLogEntry transmission) throws ServiceException;

	 public IrsTransmissionLogData buildRequestDataFile(List<IRS1095B> batch, String correctionInd, String taxYear, String originalReceipt, List<IRS1095B> errorList) throws ServiceException;

	 public IRS1095B convertSingleEntry(IrsTransmissionLogData dataFile, int sequence) throws ServiceException;

	 public ArrayList<IRS1095B> convertAllEntries(String dataFile) throws ServiceException;

}
