package gov.va.med.esr.service;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import gov.va.med.esr.common.model.ee.IRS1095B;
import gov.va.med.esr.common.model.ee.MECPeriod;
import gov.va.med.esr.common.model.messaging.IrsTransmissionLogDetailEntry;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.fw.service.ServiceException;



public interface IRSTransmissionService extends Serializable{

	public void sendSubmit(ArrayList<IRS1095B> batch, String batchType, String correctionInd, String taxYear) throws ServiceException;

	public void requestAcknowledgment(String receiptId) throws ServiceException;

	public void retransmitFailedSubmission(BigDecimal identifier) throws ServiceException;

	public void retransmitFailedPersonSubmission(BigDecimal identifier) throws ServiceException;

	public List getTransmissionsByPersonId(PersonEntityKey personID) throws ServiceException;

	public IrsTransmissionLogDetailEntry getMostRecentTransmissionForYear(PersonEntityKey personID, String taxYear, boolean dataRequired);

	public List getAllowedCorrectionYears(PersonEntityKey personID);

	public List getFailedBatchTransmissions();

	public List getFailedPersonTransmissions();

	public void submitCustomFile(String xmlFile, String correctionInd);

	public MECPeriod combineAllPeriods(BigDecimal personId, int calYear);

	public MECPeriod combineAllPeriods(BigDecimal personId);

	public List<MECPeriod> getAllPeriods(BigDecimal personId);

}
