/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

// Java classes
import java.io.Serializable;
import java.util.Set;

import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;

// EDB classes

/**
 * Project: Common
 * @author DNS   CHENJ2
 * @version 1.0
 */
public interface HistoricalInfoService extends Serializable {
   
 
   /**
    * @param key
    * @return Set<ChangeEvent> 
    * @throws ServiceException
    */
   public Set getHistoryChangeTimes( EntityKey key ) throws ServiceException;
   
   /**
    * @param event
    * @return
    * @throws ServiceException
    */
   public HistoricalInfo getHistoryByChangeTime(ChangeEvent event) throws ServiceException;
}