package gov.va.med.esr.service;

//Java classes
import gov.va.med.esr.common.batchprocess.HealthBenefitPlanData;
import gov.va.med.esr.common.model.comms.DeliveryPreference;
import gov.va.med.esr.common.model.comms.Directory;
import gov.va.med.esr.common.model.comms.DocumentAccessLog;
import gov.va.med.esr.common.model.comms.DocumentReceipt;
import gov.va.med.esr.common.model.comms.FileInfo;
import gov.va.med.esr.common.model.comms.HandBookBatchRequest;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.comms.HandbookBatchFileProcessStatistics;
import gov.va.med.esr.common.model.comms.HandbookBatchRequestStatistics;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.HandBookMailStatusType;
import gov.va.med.esr.common.model.lookup.HandBookReleaseControl;
import gov.va.med.esr.common.model.lookup.HandBookRequestStatusType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.comms.DocumentReceiptDAO;
import gov.va.med.esr.common.persistent.comms.HandbookBatchRequestDAO;
import gov.va.med.esr.service.external.person.DeliveryPreferenceInfo;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.esr.service.trigger.LetterTriggerIdentity;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * The Eligibility and Enrollment Service. Project: Common
 * 
 * @version ESR.36
 */
public interface HandBookService extends HistoricalInfoService  {

	/**
	 * HealtheVet api that exposes EE data to the enterprise. Data set exposed
	 * is largely driven by client requirements.
	 * 
	 * @param vpid
	 * @return
	 * @throws ServiceException
	 */
	List getHandbookInformation(String vpid) throws ServiceException,
			DAOException;

	/**
	 * Get the list of handbook info sorted by receipt date in descending order
	 * 
	 * @param vpid
	 * @return
	 * @throws ServiceException
	 */
	List getLatestHandbookInformation(String vpid) throws ServiceException,
			DAOException;
	
	/**
	 * This gets the raw health benefit data used to generate the Veteran Health
	 * Benefit Profile Raw Data display
	 * 
	 * @return
	 * @param vpid
	 *            id of the veteran
	 * @param receipt_id
	 *            handbook_mail_queue_id (i.e. document_receipt.receipt_string)
	 * @throws ServiceException
	 */
	List getRawProfileData(String vpid, int receipt_id) throws ServiceException;

	// CCR10386 -- added findHandbookEntriesByPersonId
	/**
	 * find a list of handbook status entries by person id
	 * 
	 * @param personId
	 *            the person identifier
	 * 
	 * @return a list of CommsLogEntry
	 */
	List findHandbookEntriesByPersonId(String personId) throws ServiceException;

	/**
	 * find a list of handbook entries in send status by person id
	 * 
	 * @param personId
	 *            the person identifier
	 * 
	 * @return a list of CommsLogEntry
	 */

	List findHandbookEntriesInSendSatusByPersonId(BigDecimal personId,
			String releaseCtl) throws ServiceException;

	/**
	 * Find a list of handbook entries in SEND_TO_CMS status, with the current
	 * system release control numbber, for the person_id provided, and the form
	 * template
	 * 
	 * @param personId
	 * @param templId
	 * @return
	 * @throws ServiceException
	 */
	List findHandbookEntriesInSendToCMSByPersonByTemp(Person person,
			ComLetterTemplateType templId) throws ServiceException;

	/**
	 * find a last handbook is return by post office by person id
	 * 
	 * @param personId
	 *            the person identifier
	 * 
	 * @return a list of CommsLogEntry
	 */
	List lastHandbookReturnPostOffice(String personId) throws ServiceException;

	void triggerHandBookPFInsert(String personId) throws ServiceException;

	/**
	 * Get the template for the Handbook
	 * 
	 * @return
	 * @throws ServiceException
	 */
	List findHandbookTemplate() throws ServiceException;

	void recordDocumentAccess(BigDecimal fileId) throws Exception;

	/**
	 * Gets a specific HandBookMailQueue record based on an entity key.
	 * 
	 * @param key
	 *            The key of the HandBookMailQueue to retrieve.
	 * 
	 * @return The HandBookMailQueue based on the specified entity key.
	 * @throws ServiceException
	 *             if any problems were encountered.
	 */
	HandBookMailQueue getHandbookMailQueueEntry(EntityKey key)
			throws ServiceException;

	void updateRemarks(HandBookMailQueue handbookMailQueue)
			throws ServiceException;

	// verify docment has been stored before update to MAILED_BY_CMS
	boolean verifyDocumentReceipt(String vpid, String uid)
			throws ServiceException;

	void saveHandBookBatchRequest(HandBookBatchRequest handBookBatchRequest)
			throws ServiceException;

	List getHandBookBatchRequests() throws ServiceException;
	
	List<HandbookBatchRequestStatistics> getHandbookBatchRequestStatistics(Date releaseDate) throws ServiceException;
	
	List getHandbookBatchFileStatistics(Date batchDate) throws ServiceException;
	
	HandbookBatchFileProcessStatistics getHandbookBatchFileProcessStatistics(Date selectedDate, Date minJobStartDate, Date maxJobEndDate) throws ServiceException;
	
	List<Date> getHandbookBatchFileProcessDateList() throws ServiceException;
	
	Date getHandbookBatchFileProcessMaxJobEndDate(Date selectedDate) throws ServiceException;
	
	Date getHandbookBatchFileProcessMinJobStartDate(Date selectedDate) throws ServiceException;
	
	List getNewHandBookBatchRequestIds() throws ServiceException;

	void saveHandBookMailQueue(HandBookMailQueue mailQueue)
			throws ServiceException;

	List getHandbookMailQueueHistory(BigDecimal key) throws ServiceException;

	List getHandbookMailQueueCommentHistory(BigDecimal key)
			throws ServiceException;

	List getHandBookMailStatusHistory(BigDecimal handBookMailQueueId)
			throws ServiceException;

	void updateHandBookBatchRequestStatus(
			HandBookBatchRequest handBookBatchRequest,
			HandBookRequestStatusType newStatus) throws ServiceException;

	HandBookBatchRequest getHandbookBatchRequestEntry(EntityKey key)
			throws ServiceException;

	void changeHandbookMailingStatus(HandBookMailQueue handbookMailQueue,
			HandBookMailStatusType status) throws ServiceException;

	// HandBookBMialQueue by identifier
	HandBookMailQueue findHandBookByIdentifier(String id)
			throws ServiceException;

	// update and save status
	void saveHandbookMailStatus(HandBookMailQueue handbookMailQueue,
			HandBookMailStatusType status) throws ServiceException;

	DocumentReceiptDAO getDocumentReceiptDao();

	void setDocumentReceiptDao(DocumentReceiptDAO documentReceiptDao);

	List findDocumentReceipts(String vpid) throws ServiceException;

	Directory findActiveVBRDirectory() throws ServiceException;

	String getVBRFileLocation(Directory dir);

	void deleteDocumentReceipt(DocumentReceipt documentReceipt)
			throws ServiceException;

	void saveDocumentReceipt(DocumentReceipt documentReceipt)
			throws ServiceException;

	void processHealthBenefitsPlanRecord(
			HealthBenefitPlanData healthBenefitPlanData,
			String pdfFileLocation, DataFileProcessExecutionContext context)
			throws ServiceException;

	List requestHandBook(String personId, LetterTriggerIdentity letterType)
			throws ServiceException;

	void requestHandBookMail(BigDecimal personId,
			ComLetterTemplateType formNum, String remark,
			String batchRequestId, BigDecimal releaseCtl)
			throws ServiceException;

	void request400HHandBookMail(BigDecimal personId, String remark,
			String batchRequestId, BigDecimal releaseCtl)
			throws ServiceException;

	// get the mailing address that was used for a specific Handbook mailing
	Address getHandBookMailingAddress(HandBookMailQueue handBookMailQueue)
			throws ServiceException;

	// determine if this person can receive a handbook.
	List checkHandbookMailValidation(Person person) throws ServiceException;

	int getEstRecordCountForBatch(String BatchId);

	HandbookBatchRequestDAO getHandbookBatchRequestDAO();

	void setHandbookBatchRequestDAO(
			HandbookBatchRequestDAO handbookBatchRequestDAO);

	Address getHandbookAddress(BigDecimal addressId) throws ServiceException;

	String getICNChecksumForVpid(String vpid) throws ServiceException;

	void processUndeliverableHandbook(HandBookMailQueue handbookMailQueue)
			throws ServiceException;

	void handleMailingResponse(HandBookMailQueue handbookMailQueue)
			throws ServiceException;

	void updateBatchRequestEstCountRecord(HandBookBatchRequest batchrequest);

	void addHandBookBatchRequest(HandBookBatchRequest handBookBatchRequest)
			throws ServiceException;

	List findAnyHandbookSentOrMailedForPersonId(String personId)
			throws ServiceException;

	DeliveryPreference findDeliveryPreferenceByPersonId(String personId)
			throws ServiceException;

	List findDeliveryPreferenceEditableStatusByPersonId(String personId)
			throws ServiceException;

//	List getDeliveryPreferenceHistory(String personId) throws ServiceException;

	/**
	 * Persist delivery preference, including insert and update.
	 * 
	 * @param deliveryPreference
	 * @throws ServiceException
	 */
	void saveDeliveryPreference(DeliveryPreference deliveryPreference)
			throws ServiceException;
	
    public HistoricalInfo getDeliveryPreferencesHistoryByChangeTime(ChangeEvent event) throws ServiceException;

    public Set getDeliveryPreferencesChangeTimes(EntityKey personID) throws ServiceException;
    public void buildDeliveryPreference(DeliveryPreferenceInfo info, DeliveryPreference dp) throws ServiceException;
    
    public FileInfo getFileInfoById(BigDecimal id) throws ServiceException;

	public ByteArrayInputStream convertXmlHandBookToPDF(File file) throws ServiceException;
	public void saveOnlineDocumentReceipt(DocumentReceipt documentReceipt)throws ServiceException;
	public HandBookReleaseControl getHandBookReleaseControl(String releaseCtl )throws ServiceException;
	
	
    
}