package gov.va.med.esr.service;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.service.ServiceException;

// The names for esr env values should be in synch with what is in init.xml
public interface EnvironmentParamService {
	String DEV_ENV = "EDEV";  
	String SQA_ENV = "ESQA"; 
	String PROD_ENV = "Production"; 
	String TRAINING_ENV = "Training"; 
	String STAGING_ENV = "Staging"; 
	String TROUBLESHOOTING_ENV = "Troubleshooting"; 
	String PERFORMANCE_ENV = "Performance"; 
	String LOCAL_ENV = "Local"; 
    
    boolean isDataClean();
    boolean isProdEnv();
    boolean isStagingEnv();
    boolean isSqaEnv();
    boolean isPreProdEnv();  // PreProd is the same as Troubleshooting
    boolean isTrainingEnv();
    
    /**
     * Determines if site is supported based on the current environment.
     * 
     * @return boolean indicating if site is supported
     *   
     * @throws ServiceException
     */
    boolean isSupportedFacility(VAFacility facility) throws ServiceException;
  
}
