package gov.va.med.esr.service;

import gov.va.med.esr.common.model.security.EEServiceRequest;
import gov.va.med.esr.common.model.security.EEServiceRequestLite;
import gov.va.med.esr.common.model.security.EEServiceUser;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;


import java.util.List;
import java.util.Set;

public interface EEServiceAdminService {

    public List getEEServiceRequests() throws ServiceException;

    public List getEEServiceLiteRequests() throws ServiceException;

    public List getEEServiceUsers() throws ServiceException;

    public EEServiceUser getEEServiceUser(String userName) throws ServiceException;

    public EEServiceRequest getEEserviceRequest(EntityKey eeServiceRequestId) throws ServiceException ;

    public Set getEEServiceRequestFieldsByRequest(EntityKey eeServiceRequestId) throws ServiceException;

    public EEServiceRequestLite getEEserviceRequestLite(EntityKey eeServiceRequestId) throws ServiceException ;

    public void saveEEServiceRequest(EEServiceRequest eeServiceRequest) throws ServiceException ;

    public EEServiceRequest getEEServicerequestByName(String name) throws ServiceException;

    public EEServiceRequestLite getEEServicerequestLiteByName(String name) throws ServiceException;

    public EEServiceUser getEEserviceUser(EntityKey eeServiceUserId) throws ServiceException ;

    public void saveEEServiceUser(EEServiceUser eeServiceUser) throws ServiceException ;

    public void applyRequest(EESummary eeSummary, String accountName, String requestName) throws ServiceException;

   
    }
