/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.service;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.trigger.BulletinTriggerEvent;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;

/**
 * Initial javadoc for class EEResult.
 * TODO - Add content here
 * 
 * Created Sep 14, 2006 11:06:46 AM
 * @author DNS   BOHMEG
 */
public class EEResult implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 9093716638244007955L;
	private PersonEntityKey personEntityKey;
	private Person incomingPerson;
	private Person updatedPerson;
	private Set triggerEventsForHL7Messages;
	private Set triggerEventsForBulletins;
	private Set triggerEventsForLetters;
	private boolean eeChange;
	private boolean calculated;

	public EEResult(PersonEntityKey personEntityKey) {
		this.personEntityKey = personEntityKey;
	}
	
	public EEResult(Person updatedPerson) {
		this(null, updatedPerson);
	}
	
	public EEResult(Person incomingPerson, Person updatedPerson) {
		this.incomingPerson = incomingPerson;
		setUpdatedPerson(updatedPerson);
	}

	/**
	 * @return Returns the incomingPerson.
	 */
	public Person getIncomingPerson() {
		return incomingPerson;
	}

	/**
	 * @param incomingPerson The incomingPerson to set.
	 */
	public void setIncomingPerson(Person incomingPerson) {
		this.incomingPerson = incomingPerson;
	}

	/**
	 * @return Returns the updatedPerson.
	 */
	public Person getUpdatedPerson() {
		return updatedPerson;
	}

	/**
	 * @param updatedPerson The updatedPerson to set.
	 */
	public void setUpdatedPerson(Person updatedPerson) {
		this.updatedPerson = updatedPerson;
		if(updatedPerson != null) {
			this.personEntityKey = updatedPerson.getPersonEntityKey();
			calculated = true;
		}
	}

	/**
	 * @return Returns the triggerEventsForBulletins.
	 */
	public Set getTriggerEventsForBulletins() {
		return triggerEventsForBulletins;
	}

	/**
	 * @param triggerEventsForBulletins The triggerEventsForBulletins to set.
	 */
	public void setTriggerEventsForBulletins(Set triggerEventsForBulletins) {
		this.triggerEventsForBulletins = triggerEventsForBulletins;
	}
	
	public void addBulletinTriggerEvent(BulletinTriggerEvent event) {
		if(triggerEventsForBulletins == null)
			triggerEventsForBulletins = new HashSet();
		triggerEventsForBulletins.add(event);
	}

	/**
	 * @return Returns the triggerEventsForLetters.
	 */
	public Set getTriggerEventsForLetters() {
		return triggerEventsForLetters;
	}

	/**
	 * @param triggerEventsForLetters The triggerEventsForLetters to set.
	 */
	public void setTriggerEventsForLetters(Set triggerEventsForLetters) {
		this.triggerEventsForLetters = triggerEventsForLetters;
	}

	public void addLetterTriggerEvent(LetterTriggerEvent event) {
		if(triggerEventsForLetters == null)
			triggerEventsForLetters = new HashSet();
		triggerEventsForLetters.add(event);
	}
	
	/**
	 * @return Returns the triggerEventsForHL7Messages.
	 */
	public Set getTriggerEventsForHL7Messages() {
		return triggerEventsForHL7Messages;
	}

	/**
	 * @param triggerEventsForHL7Messages The triggerEventsForHL7Messages to set.
	 */
	public void setTriggerEventsForHL7Messages(Set triggerEventsForHL7Messages) {
		this.triggerEventsForHL7Messages = triggerEventsForHL7Messages;
	}
	
	public void addHL7MessageTriggerEvent(PersonTriggerEvent event) {
		if(triggerEventsForHL7Messages == null)
			triggerEventsForHL7Messages = new HashSet();
		triggerEventsForHL7Messages.add(event);
	}
	

	/**
	 * @return Returns the eeChange.
	 */
	public boolean isEeChange() {
		return eeChange;
	}

	/**
	 * @param eeChange The eeChange to set.
	 */
	public void setEeChange(boolean eeChange) {
		this.eeChange = eeChange;
	}

	/**
	 * @return Returns the personEntityKey.
	 */
	public PersonEntityKey getPersonEntityKey() {
		return personEntityKey;
	}

	/**
	 * @param personEntityKey The personEntityKey to set.
	 */
	public void setPersonEntityKey(PersonEntityKey personEntityKey) {
		this.personEntityKey = personEntityKey;
	}

	/**
	 * @return Returns the calculated.
	 */
	public boolean isCalculated() {
		return calculated;
	}

	/**
	 * @param calculated The calculated to set.
	 */
	public void setCalculated(boolean calculated) {
		this.calculated = calculated;
	}
}
