// Package 
package gov.va.med.esr.service;

// Java Classes
import java.io.Serializable;
import java.util.Date;

// Library Classes
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * This class extends ReportFilterSearchQueryInfo by adding additional search parameters needed to perform a
 * completed reports search.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class CompletedReportsSearchQueryInfo extends ReportFilterSearchQueryInfo implements Serializable
{
    private String reportParameters = null;
    private Date inactivatedDate=null;
    private ReportStatus reportStatus=null;
    private static final long serialVersionUID = -8074807667874525804L;

    public String getReportParameters()
    {
        return reportParameters;
    }

    public void setReportParameters(String reportParameters)
    {
        this.reportParameters = reportParameters;
    }

    /**
     * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);
        builder.append("reportParameters", getReportParameters());
    }

    public Date getInactivatedDate() {
        return inactivatedDate;
    }

    public void setInactivatedDate(Date archivedDate) {
        this.inactivatedDate = archivedDate;
    }

    public ReportStatus getReportStatus() {
        return reportStatus;
    }

    public void setReportStatus(ReportStatus reportStatus) {
        this.reportStatus = reportStatus;
    }
}
