/*
 * Created on Apr 26, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.service;

import java.io.Serializable;
import java.util.List;

import gov.va.med.fw.service.ServiceException;

import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.esr.service.trigger.LetterTriggerIdentity;

/**
 * @author George Tsai
 * <pre>
 * NOTE: the service is obtained from spring framework by calling
 *          broker.getComponent(<b>"commsLetterRequestService"</b>);  
 *       Please see comms/business_services.xml for details
 * </pre>
 */

public interface CommsLetterRequestService extends Serializable {
    
    public static final String CONTEXT_AAC_EXPORT = "AAC_EXPORT";
    
    public static final String CONTEXT_CMS_EXPORT = "CMS_EXPORT";    
    
    public static final String CONTEXT_REQUEST_LETTER = "REQUEST_LETTER";    
    
    
	/**
     * Request an AAC letter to AAC export letter batch.
     * This can be called by UI synchronously or can be called by JMS consumer process asynchronously.
     * 
     * @param person the person this letter is sending to
     * @param letterType Details about the target letter
     * @param workflowCaseId the workflow case Id for the person, if applicable (not used in I3)
     * @param mailType LetterTriggerEvent.MANUAL_MAIL; LetterTriggerEvent.REMAIL; LetterTriggerEvent.HISTORIC_MAIL; LetterTriggerEvent.AUTO_MAIL; 
     * Please see gov.va.med.esr.service.trigger.LetterTriggerEvent for types
     * @param override indicate if this request is a result of user override, null means false
     * @return a list of two lists of error messages. The first list is the required fields error messages. The second list is the condition to send error messages. Empty list if no error messages.
     * @throws ServiceException
     */
    List requestAacLetter(Person person, 
            LetterTriggerIdentity letterType, 
            String workflowCaseId, 
            LetterTriggerEvent.MailType mailType,
            Boolean override) throws ServiceException;

    /**
     * Request an AAC or CMS letter to AAC/CMS export letter batch.
     * This can be called by JMS consumer process asynchronously.
     * 
     * @param person
     * @param letterType
     * @param letterTriggerEvent TODO
     * @return
     * @throws ServiceException
     */
    public List requestLetter(Person person, 
            LetterTriggerIdentity letterType, 
            LetterTriggerEvent letterTriggerEvent) throws ServiceException;    
    
    /**
     * Request an AAC letter to AAC export letter batch.
     * This can be called by UI synchronously or can be called by JMS consumer process asynchronously.
     * 
     * @param person the person this letter is sending to
     * @param letterType Details about the target letter
     * @param workflowCaseId the workflow case Id for the person, if applicable (not used in I3)
     * @param mailType LetterTriggerEvent.MANUAL_MAIL; LetterTriggerEvent.REMAIL; LetterTriggerEvent.HISTORIC_MAIL; LetterTriggerEvent.AUTO_MAIL; 
     * Please see gov.va.med.esr.service.trigger.LetterTriggerEvent for types
     * @param override indicate if this request is a result of user override, null means false
     * @param actioncomment user comment
     * @return a list of two lists of error messages. The first list is the required fields error messages. The second list is the condition to send error messages. Empty list if no error messages.
     * @throws ServiceException
     */    
    List requestAacLetter(Person person, 
    		LetterTriggerIdentity letterType, 
            String workflowCaseId, 
            LetterTriggerEvent.MailType mailType,
            Boolean override,
            String actionComment) throws ServiceException;

    /**
     * Check letter rules and update mailing log for an AAC letter request.
     * This can be used at letter request time (CommsLetterRequestService.requestAacLetter()) 
     * 
     * @param person the person this letter is sending to
     * @param formNumber the form number of this letter
     * @param workflowCaseId the workflow case Id for the person, if applicable (not used in I3)
     * @param mailType LetterTriggerEvent.MANUAL_MAIL; LetterTriggerEvent.REMAIL; LetterTriggerEvent.HISTORIC_MAIL; LetterTriggerEvent.AUTO_MAIL; 
     * Please see gov.va.med.esr.service.trigger.LetterTriggerEvent for types
     * @param override indicate if this request is a result of user override, null means false
     * @param logEntry the log entry to be inserted (new, created at request time) or 
     * to be updated (existing log entry, at batch time)
     * @param categoryType a.k.a subject of the letter (V,S,D)
     * 
     * @return a list of two lists of error messages. The first list is the required fields error messages. The second list is the condition to send error messages. Empty list if no error messages.
     * @throws ServiceException
     */       
    
    List processLetterRules(Person person, 
            ComLetterTemplateType formNum, 
            String workflowCaseId, 
            LetterTriggerEvent.MailType mailType,
            Boolean override,
            CommsLogEntry logEntry,
            String categoryType) throws ServiceException;
    
    /**
     * Check letter rules and update mailing log specifically for AAC Export process.
     * This can be used at letter batch process time (AacExportCommand.execute()). 
     * 
     * 
     * @param person the person this letter is sending to
     * @param formNumber the form number of this letter
     * @param workflowCaseId the workflow case Id for the person, if applicable (not used in I3)
     * @param mailType LetterTriggerEvent.MANUAL_MAIL; LetterTriggerEvent.REMAIL; LetterTriggerEvent.HISTORIC_MAIL; LetterTriggerEvent.AUTO_MAIL; 
     * Please see gov.va.med.esr.service.trigger.LetterTriggerEvent for types
     * @param override indicate if this request is a result of user override, null means false
     * @param logEntry the log entry to be inserted (new, created at request time) or 
     * to be updated (existing log entry, at batch time)
     * @param categoryType a.k.a subject of the letter (V,S,D)
     * 
     * @return a list of two lists of error messages. The first list is the required fields error messages. The second list is the condition to send error messages. Empty list if no error messages.
     * @throws ServiceException
     */           
    List processLetterRulesForAACExport(Person person, 
            ComLetterTemplateType formNum, 
            String workflowCaseId, 
            LetterTriggerEvent.MailType mailType,
            Boolean override,
            CommsLogEntry logEntry,
            String categoryType) throws ServiceException;    

    /**
     * Cancel an existing AAC letter request before it is sent to AAC. This is valid only if the mailing status is 'Send to AAC' (BR 5271)
     * 
     * 
     * @return a Boolean to indicate if the cancel operation is successful.
     * @throws ServiceException
     */
    Boolean cancelLetterRequest(CommsLogEntry commsLogEntry) throws ServiceException;

    /*
     * R3/R4 Features from UC Manage Communications Log
     */
    
    /**
     * Get a list of form numbers that are available for manually mailing to AAC.
     * 
     * @return a list of CommsTemplate
     * @throws ServiceException
     */
    List getAvailableLettersForMailing() throws ServiceException;

}
