/*
 * Created on Apr 26, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.service;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.fw.service.ServiceException;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;

/**
 * @author George Tsai
 * <pre>
 * NOTE: 1. the service is obtained from spring framework by calling
 *             broker.getComponent(<b>"commsEmailBulletinService"</b>);
 *          Please see comms/business_services.xml for details
 *       2. If the "from" is empty, a default "from" value will be used.
 *          Please see bean "mailMessage" in comms/business_services.xml
 * </pre>
 */
public interface CommsEmailBulletinService extends Serializable {

    /**
     * Send an email Bulletin in ESR system
     * @param bulletinName name of the email bulletin
     * @param dataMap tag-value pairs of the data needed for the tag replacement in bulletin text.
     * @param person the person that this email is pertaining to.
     * <br><br>
     * Notice: the tag name must match the tag in the mail bulletin text exactly for 
     * a correct tag replacement. For example, a bulletin text "Dear ~FirstName~," will be replaced 
     * by "Dear James," if dataTable has a key-value pair of "FirstName"-"James" stored.
     * @throws ServiceException
     */
    void sendEmailBulletin(BulletinTrigger.DataType bulletinName, Map dataMap, Person person) throws ServiceException;
  
    /**
     * Get an empty string value bulletin data table with data elements used in a bulletin as the keys. 
     * This empty-value hashtable will be used to populate values for sending an email bulletin. 
     * @param bulletinName name of the email bulletin
     * @return Hashtable with keys of the data elements and empty string as values  
     * @throws ServiceException
     */
    Hashtable getEmptyBulletinDataTable(String bulletinName) throws ServiceException;
    
    /**
     * Send an email Bulletin in ESR system. The bulletin has static content, therefore no parameters needed.
     * @param bulletinName name of the email bulletin
     * @param emailAddress is the email address bulletin will be sent to.
     * @throws ServiceException
     */
    void sendEmailBulletin(BulletinTrigger.DataType bulletinType, String emailAddress) throws ServiceException;
    
    /**
     * Send an email Bulletin with dynamic email content replacement with a data map and a to email list.
     * @param bullName name of the email bulletin
     * @param dataMap tag-value pairs of the data needed for the tag replacement in bulletin text
     * @param toList list of the email addresses bulletin will be sent to
     * @throws ServiceException
     */
    public void sendEmailBulletinTo(BulletinTrigger.DataType bullName,
			Map dataMap, String[] toList) throws ServiceException;
    
    /**
     * Send a simple ASCII text email
     * @param from the "from" field
     * @param toList the "to" email list, array of email address(es) 
     * @param ccList the "cc" email list, array of email address(es)
     * @param subject the email subject line
     * @param text the email body text 
     * @throws ServiceException
     */
    void sendSimpleMailMessage(String from, String[] toList, String[] ccList, String subject, String text) throws ServiceException;
    
	void sendVOAWorkflowEmailBulletin (
			BulletinTrigger.DataType bulletinName,
			Map dataMap, Person person, String formType)throws ServiceException;

}
