/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

// Java classes
import java.util.Set;

// Library classes

// Framework classes
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;

// EDB classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;


/**
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public interface ClinicalDeterminationService extends HistoricalInfoService {
    /**
     * @param personID
     * @return
     */
    public Set getClinicalDeterminationHistoryChangeTimes( EntityKey personID ) throws ServiceException;

    /**
     * @param event
     * @return
     */
    public HistoricalInfo getClinicalDeterminationHistoryByChangeTime( ChangeEvent event ) throws ServiceException;
    
    /**
     * @param personID
     * @return
     */
    public Set getRetiredCDHistoryChangeTimes( EntityKey personID ) throws ServiceException;

    /**
     * @param event
     * @return
     */
    public HistoricalInfo getRetiredCDHistoryByChangeTime( ChangeEvent event ) throws ServiceException;

    public Person processCdForCleanup(PersonEntityKey key) throws ServiceException;        
}
