/********************************************************************
 * Copyright  2004-2005 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

// Java Classes

// Framework classes
import java.io.Serializable;

import gov.va.med.esr.common.batchprocess.CampLejeuneImportData;
import gov.va.med.esr.common.model.person.Person;

import gov.va.med.fw.service.ServiceException;

/**
 * Service to process	Camp Lejeune  data
 * @author DNS   TSAIG
 *
 */
public interface CampLejeuneService extends Serializable{
  	

	/**
	 * get the person record from CLEAR Import data
	 * @param data
	 * @return clone onFile person with incoming CLEAR CLV data set
	 * @throws ServiceException
	 */
	public Person findPersonWithCLEARData(CampLejeuneImportData data)throws ServiceException;
   
	
	/**
	 * process the person record from CLEAR Import person with Enrollment business rules 
	 * @param incoming Person with CLEAR data, onFile Person found in ES record
	 * @return String[] - [0] old priority group, [1] new priority group, [2] reason txt for creating an exception record with reason. Default are three empty Strings "".
	 * @throws ServiceException
	 */
	public String[] processCLEARData(Person incoming) throws ServiceException;
 
}