package gov.va.med.esr.service;

import java.io.Serializable;
import java.util.List;

import gov.va.med.esr.common.model.lookup.ApplicationStatus;
import gov.va.med.esr.common.model.person.ApplicationInProcess;
import gov.va.med.esr.common.model.person.EnrollmentApplication;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.service.ServiceException;

public interface ApplicationInProcessService extends Serializable {

	public void savePersonInProcess(Person person, ApplicationStatus applicationStatus) throws Exception;
	
	/**
	 * Looks up an Enrollment Application by shortVPID
	 * @param shortVPID The shortVPID to lookup
	 * @return EnrollmentApplication
	 */	
	public EnrollmentApplication getEnrollmentApplicationByIcn(String shortVPID) throws ServiceException;

	
	/**
	 * Looks up an ApplicationInProcess by shortVPID
	 * @param shortVPID The shortVPID to lookup
	 * @return ApplicationInProcess
	 */	
	public ApplicationInProcess getByIcn(String shortVPID) throws ServiceException;

	/**
	 * Looks up a person that is In-Process or New Application, by shortVPID, and returns a Person.
	 * @param shortVPID The shortVPID to lookup
	 * @return A Person object.
	 */	
	public Person getInProcessPersonByIcn(String shortVPID) throws ServiceException;
	
	/**
	 * Get a person that has Complete status, by ICN.
	 * For use by post-AAP rules flows, etc.
	 *  
	 * @param shortVPID
	 * @return
	 * @throws ServiceException
	 */
	public Person getCompletedPersonByIcn(String shortVPID) throws ServiceException;	
	
	/**
	 * Looks up a person by ssn and returns a list of Person objects.  This list may be empty.
	 * @param ssn The ssn to lookup
	 * @return A list of Person objects.
	 */	
	// public List getBySsn(String ssn);
	 
	/**
	 * Is a person has registration status of "In Process"
	 * @param ssn The ssn to lookup
	 * @return boolean.
	 */		 
	 public boolean isInProcess(Person person) throws ServiceException;
	 
	/**
	 * Get the application status for a person with shortVPID (VPID)
	 * @param a short vpid value
	 * @return ApplicationStatus.
	 */		 
	 public List getApplicationStatusesByIcn(String shortVPID) throws ServiceException;
	 
	/**
	 * See if the specified application status exist in the list of Application Statuses 
	 * @param applicationStatusList
	 * @param status
	 * @return boolean
	 * @throws ServiceException
	 */
	public boolean existsRecordWithStatus(List applicationStatusList, ApplicationStatus status)  throws ServiceException;

	/**
	 * Performs business logic to completeAddPersonRegistration
	 * @param incoming
	 */
	public Person processCompleteRegistration(Person incoming) throws ServiceException;

	/**
	 * For a search result returned from IDM, with no ADR Person table stub, and no in-process record.  Add both.
	 * 
	 * @param incoming
	 * @throws ServiceException
	 */
	public void processAddPersonStubAndSaveInProcess(Person incoming) throws ServiceException;
	 
}
