/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.validator.person;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.validator.AbstractDQValidator;

/**
 * @author Martin Francisco
 */
public class NameDQValidator
    extends AbstractDQValidator
{
    private static final long serialVersionUID = -2735803902519019255L;

    public NameDQValidator()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang.Object)
     */
    protected void processValidate(Object input) throws ValidatorException
    {
        this.validateMinimumDataProvided((Name)input);
    }

    private void validateMinimumDataProvided(Name input)
        throws ValidatorException
    {
        if(input.getFamilyName() == null)
        {
            throw new ValidatorException("Person must have a Last Name");
        }
    }
}