/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.validator.person;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.validator.AbstractDQValidator;

/**
 * @author Martin Francisco
 */
public class DeathRecordDQValidator
    extends AbstractDQValidator
{
    private static final long serialVersionUID = 1044269338380027380L;

    public DeathRecordDQValidator()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang.Object)
     */
    protected void processValidate(Object input) throws ValidatorException
    {
        this.validateMinimumDataProvided((DeathRecord)input);
    }

    private void validateMinimumDataProvided(DeathRecord input)
        throws ValidatorException
    {
        if((input.getDeathDate() == null) && (input.getLazarusDate() == null))
        {
            throw new ValidatorException(
                "Death Date or Lazarus Date is required");
        }
    }
}