/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.validator.person;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.validator.AbstractDQValidator;

/**
 * @author Martin Francisco
 */
public class BirthRecordDQValidator
    extends AbstractDQValidator
{
    /**
	 * 
	 */
	private static final long serialVersionUID = 2094180000870502431L;

	public BirthRecordDQValidator()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang.Object)
     */
    protected void processValidate(Object input) throws ValidatorException
    {
        this.validateMinimumDataProvided((BirthRecord)input);
    }

    private void validateMinimumDataProvided(BirthRecord input)
        throws ValidatorException
    {
        if(input.getBirthDate() == null)
        {
            throw new ValidatorException("Date of Birth must be entered");
        }
    }
}