/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.validator.party;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.validator.AbstractDQValidator;

/**
 * @author Martin Francisco
 */
public class PhoneDQValidator
    extends AbstractDQValidator
{
    private static final long serialVersionUID = 7043528414033265102L;

    public PhoneDQValidator()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang.Object)
     */
    protected void processValidate(Object input) throws ValidatorException
    {
        this.validateMinimumDataProvided((Phone)input);
    }

    private void validateMinimumDataProvided(Phone input)
        throws ValidatorException
    {
        if(input.getPhoneNumber() == null)
        {
            throw new ValidatorException("Phone Number is required");
        }
    }
}