/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.validator.party;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.validator.AbstractDQValidator;

/**
 * @author Martin Francisco
 */
public class ElectronicAddressDQValidator
    extends AbstractDQValidator
{
    private static final long serialVersionUID = -8487354830365113448L;

    public ElectronicAddressDQValidator()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang.Object)
     */
    protected void processValidate(Object input) throws ValidatorException
    {
        this.validateMinimumDataProvided((Email)input);
    }

    private void validateMinimumDataProvided(Email input)
        throws ValidatorException
    {
        if(input.getAddress() == null)
        {
            throw new ValidatorException("Address is required");
        }
    }
}