/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.validator.party;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.validator.AbstractDQValidator;

/**
 * @author Martin Francisco
 */
public class AddressDQValidator
    extends AbstractDQValidator
{
    /**
	 * 
	 */
	private static final long serialVersionUID = 2506843285088051911L;

	public AddressDQValidator()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang.Object)
     */
    protected void processValidate(Object input) throws ValidatorException
    {
        this.validateMinimumDataProvided((Address)input);
    }

    private void validateMinimumDataProvided(Address input)
        throws ValidatorException
    {
        if(input.getLine1() == null)
        {
            throw new ValidatorException("Line 1 is required");
        }
        else if(input.getCity() == null)
        {
            throw new ValidatorException("City is required");
        }
    }
}