/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.validator.financials;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes
import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.validator.AbstractDQValidator;

/**
 * @author Martin Francisco
 */
public class HardshipDQValidator
    extends AbstractDQValidator
{
    private static final long serialVersionUID = -3904123997442495973L;

    public HardshipDQValidator()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang.Object)
     */
    protected void processValidate(Object input) throws ValidatorException
    {
        this.validateMinimumDataProvided((Hardship)input);
    }

    private void validateMinimumDataProvided(Hardship input)
        throws ValidatorException
    {
        if(input.getHardshipGranted() == null)
        {
            throw new ValidatorException("Hardship Granted is required");
        }
    }
}