/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.validator.financials;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.validator.AbstractDQValidator;

/**
 * @author Martin Francisco
 */
public class ExpenseDQValidator
    extends AbstractDQValidator
{
    private static final long serialVersionUID = 4567403433166473874L;

    public ExpenseDQValidator()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang.Object)
     */
    protected void processValidate(Object input) throws ValidatorException
    {
        this.validateMinimumDataProvided((Expense)input);
    }

    private void validateMinimumDataProvided(Expense input)
        throws ValidatorException
    {
        if(input.getAmount() == null)
        {
            throw new ValidatorException("Amount is required");
        }
    }
}