/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.validator.financials;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes
import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.validator.AbstractDQValidator;

/**
 * @author Martin Francisco
 */
public class BeneficiaryTravelDQValidator
    extends AbstractDQValidator
{
    /**
	 * 
	 */
	private static final long serialVersionUID = -5254832046946753373L;

	public BeneficiaryTravelDQValidator()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang.Object)
     */
    protected void processValidate(Object input) throws ValidatorException
    {
        this.validateMinimumDataProvided((BeneficiaryTravel)input);
    }

    private void validateMinimumDataProvided(BeneficiaryTravel input)
        throws ValidatorException
    {
        if(input.getClaimDate() == null)
        {
            throw new ValidatorException("Claim Date is required");
        }
        else if(input.isEligible() == null)
        {
            throw new ValidatorException("Eligible is required");
        }
    }
}