/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.validator.financials;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes
import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.validator.AbstractDQValidator;

/**
 * @author Martin Francisco
 */
public class AssetDQValidator
    extends AbstractDQValidator
{
    /**
	 * 
	 */
	private static final long serialVersionUID = -8550909014364667681L;

	public AssetDQValidator()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang.Object)
     */
    protected void processValidate(Object input) throws ValidatorException
    {
        this.validateMinimumDataProvided((Asset)input);
    }

    private void validateMinimumDataProvided(Asset input)
        throws ValidatorException
    {
        if(input.getAmount() == null)
        {
            throw new ValidatorException("Amount is required");
        }
    }
}