/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.validator.ee;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Validator;
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.validator.AbstractDQValidator;

/**
 * @author Martin Francisco
 */
public class MilitaryServiceDQValidator
    extends AbstractDQValidator
{
    private static final long serialVersionUID = -3875870975958578036L;
    private Validator combatExperienceValidator;
    private Validator conflictExperienceValidator;
    private Validator militaryServiceEpisodeValidator;

    public MilitaryServiceDQValidator()
    {
        super();
    }

    public Validator getCombatExperienceValidator()
    {
        return this.combatExperienceValidator;
    }

    public void setCombatExperienceValidator(Validator combatExperienceValidator)
    {
        this.combatExperienceValidator = combatExperienceValidator;
    }

    public Validator getConflictExperienceValidator()
    {
        return this.conflictExperienceValidator;
    }

    public void setConflictExperienceValidator(
        Validator conflictExperienceValidator)
    {
        this.conflictExperienceValidator = conflictExperienceValidator;
    }

    public Validator getMilitaryServiceEpisodeValidator()
    {
        return this.militaryServiceEpisodeValidator;
    }

    public void setMilitaryServiceEpisodeValidator(
        Validator militaryServiceEpisodeValidator)
    {
        this.militaryServiceEpisodeValidator = militaryServiceEpisodeValidator;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang.Object)
     */
    protected void processValidate(Object input) throws ValidatorException
    {
        this.validateMinimumDataProvided((MilitaryService)input);
        this.validateDependencies((MilitaryService)input);
    }

    private void validateMinimumDataProvided(MilitaryService input)
        throws ValidatorException
    {
    }

    private void validateDependencies(MilitaryService input)
        throws ValidatorException
    {
        // FIXME structure change
//        super.validateSet(this.conflictExperienceValidator, input.
//            .getConflictExperiences());
//        super.validateSet(this.militaryServiceEpisodeValidator, input
//            .getMilitaryServiceEpisodes());
    }
}