/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.validator.ee;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.validator.AbstractDQValidator;

/**
 * @author Martin Francisco
 */
public class ApplicationDQValidator
    extends AbstractDQValidator
{
    /**
	 * 
	 */
	private static final long serialVersionUID = 3707923891246823592L;

	public ApplicationDQValidator()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang.Object)
     */
    protected void processValidate(Object input) throws ValidatorException
    {
        this.validateMinimumDataProvided((Application)input);
    }

    private void validateMinimumDataProvided(Application input)
        throws ValidatorException
    {
        if(input.getApplicationDate() == null)
        {
            throw new ValidatorException("Application Date is required");
        }
    }
}