package gov.va.med.esr.common.util;

import java.io.IOException;
import java.util.TimerTask;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;

/**
 * 
 * Writes output to the web browser.
 * 
 */
public class FeedbackTask extends TimerTask {
    private HttpServletResponse servletResponse;

    private String message;

    private JspWriter jspWriter;

    /**
     * 
     * @param jspWriter
     *            the jsp output stream
     * @param servletResponse
     * @param message
     *            the message to write to the output stream
     */
    public FeedbackTask(JspWriter jspWriter,
            HttpServletResponse servletResponse, String message) {
        super();
        this.servletResponse = servletResponse;
        this.message = message;
        this.jspWriter = jspWriter;
    }

    /**
     * writes the message and flushes the buffer
     */
    public void run() {
        try {
            jspWriter.println(message);
            servletResponse.flushBuffer();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((message == null) ? 0 : message.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        final FeedbackTask other = (FeedbackTask) obj;
        if (message == null) {
            if (other.message != null)
                return false;
        } else if (!message.equals(other.message))
            return false;
        return true;
    }
}
