package gov.va.med.esr.common.util;

import gov.va.med.esr.common.model.ee.EnrollmentDetermination;

import java.math.BigDecimal;
import java.util.Comparator;

/**
 * 
 * Compares two enrollment determinations by the value of their entity keys.
 * 
 * 
 */
public class EnrollmentDeterminationComparatorByEntityKeyValue implements
        Comparator {

    /**
     * @return a value less than 0 if arg0's entity key value is less than arg1;
     *         and a value greater than 0 if arg0's entity key value is greater
     *         than arg1, and 0 if both are null or the same value.
     */
    public int compare(Object arg0, Object arg1) {
        EnrollmentDetermination a = (EnrollmentDetermination) arg0;
        EnrollmentDetermination b = (EnrollmentDetermination) arg1;
        return (a.getEntityKey() == null && b.getEntityKey() == null) ? 0
                : (((BigDecimal) a.getEntityKey().getKeyValue())
                        .compareTo((BigDecimal) b.getEntityKey().getKeyValue()));
    }

}
