package gov.va.med.esr.common.util;

import java.util.Comparator;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;

/**
 * 
 * Compares two enrollment determinations by effective date.
 * 
 * 
 */
public class EnrollmentDeterminationComparatorByEffectiveDate  implements
        Comparator {

    /**
     * @return a value less than 0 if arg0 is before arg1; and a value greater
     *         than 0 if arg0 is after arg1, and 0 if both are null or the same
     *         date.
     * @throws IllegalArgumentException
     *             if one or the other date is null, but not both
     */
    public int compare(Object arg0, Object arg1) {
        EnrollmentDetermination a = (EnrollmentDetermination) arg0;
        EnrollmentDetermination b = (EnrollmentDetermination) arg1;
        
        if (a.getEffectiveDate() == null && b.getEffectiveDate() != null) {
            throw new IllegalArgumentException(
                    "Cannot compare dates. arg0's effective date is null but arg1's is not");
        }
        if (a.getEffectiveDate() != null && b.getEffectiveDate() == null) {
            throw new IllegalArgumentException(
                    "Cannot compare dates. arg1's effective date is null is null but arg0's is not");
        }
        
        return (a.getEffectiveDate() == null && b.getEffectiveDate() == null) ? 0
                : (a.getEffectiveDate().compareTo(b.getEffectiveDate()));
    }
}
