/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.util;

import java.util.Date;

import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.fw.util.DateComparator;

// Java classes

// Library classes

// Framework classes

// ESR classes

/**
 * Compare 2 conflict experiences  
 *
 * Project: Common</br>
 * Created on: 5:55:33 PM </br>
 *
 * @author DNS   LEV
 */
public class ConflictExperienceComparator extends DateComparator {

	/**
	 * An instance of compareEndDate
	 */
	private boolean compareEndDate = true;
	
	/**
	 * A default constructor
	 */
	public ConflictExperienceComparator( boolean compareEndDate ) {
		super();
		this.compareEndDate = compareEndDate;
	}

	/**
	 * A default constructor
	 */
	public ConflictExperienceComparator() {
		this( true );
	}

	/**
	 * @see gov.va.med.fw.util.DateComparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object arg1, Object arg2) {
		// Return -1 for conflict1 < conflict2. 1 for conflict1 > conflict2. 0 for equality
		int equal = 0;
		if( arg1 instanceof ConflictExperience && arg2 instanceof ConflictExperience ) {
			ConflictExperience conflict1 = (ConflictExperience)arg1;
			ConflictExperience conflict2 = (ConflictExperience)arg2;
			
			Date conflict1_date = null;
			Date conflict2_date = null;
			
			if( compareEndDate ) {
				conflict1_date = ImpreciseDateUtils.getDateWithDefault( conflict1.getEndDate() ); 
				conflict2_date = ImpreciseDateUtils.getDateWithDefault( conflict2.getEndDate() ); 
			}
			else {
				conflict1_date = ImpreciseDateUtils.getDateWithDefault( conflict1.getStartDate() ); 
				conflict2_date = ImpreciseDateUtils.getDateWithDefault( conflict2.getStartDate() ); 
			}

			// Compare the 2 episodes for the most recent
			if( conflict1_date != null && conflict2_date != null ) {
				equal = super.compare( conflict1_date, conflict2_date );
			}
		}
		return equal;
	}
}
