package gov.va.med.esr.common.util;

import java.util.Date;

import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.fw.util.DateComparator;

public class CombatServiceComparator extends DateComparator {
	/**
	 * An instance of compareEndDate
	 */
	private boolean compareEndDate = true;
	
	/**
	 * A default constructor
	 */
	public CombatServiceComparator( boolean compareEndDate ) {
		super();
		this.compareEndDate = compareEndDate;
	}

	/**
	 * A default constructor
	 */
	public CombatServiceComparator() {
		this( true );
	}

	/**
	 * @see gov.va.med.fw.util.DateComparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object arg1, Object arg2) {
		// Return -1 for combatService1 < combatService2. 1 for combatService1 > combatService2. 0 for equality
		int equal = 0;
		if (arg1 instanceof CombatService && arg2 instanceof CombatService) {
			CombatService combatService1 = (CombatService)arg1;
			CombatService combatService2 = (CombatService)arg2;
			
			Date combatService1_date = null;
			Date combatService2_date = null;
			
			if( compareEndDate ) {
				combatService1_date = ImpreciseDateUtils.getDateWithDefault(combatService1.getPayEndDate()); 
				combatService2_date = ImpreciseDateUtils.getDateWithDefault(combatService2.getPayEndDate()); 
			}
			else {
				combatService1_date = ImpreciseDateUtils.getDateWithDefault(combatService1.getPayStartDate()); 
				combatService2_date = ImpreciseDateUtils.getDateWithDefault(combatService2.getPayStartDate()); 
			}

			if( combatService1_date != null && combatService2_date != null ) {
				equal = super.compare( combatService1_date, combatService2_date );
			} else {
                if(combatService1_date == null && combatService2_date == null) {
                    equal = 0;
                } else if(combatService1_date == null) {
                    equal = -1;
                } else {
                    equal = 1;
                }
            }
		}
		return equal;
	}
}
