/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.util;

import java.util.Date;

import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.AbstractCombatEpisode;
import gov.va.med.fw.util.DateComparator;

/**
 * Compare 2 combat episodes  
 *
 * Project: Common</br>
 * Created on: 5:55:33 PM </br>
 *
 * @author Muddaiah Ranga
 */
public class CombatEpisodeComparator extends DateComparator {

	/**
	 * An instance of compareEndDate
	 */
	private boolean compareEndDate = true;
	
	/**
	 * A default constructor
	 */
	public CombatEpisodeComparator( boolean compareEndDate ) {
		super();
		this.compareEndDate = compareEndDate;
	}

	/**
	 * A default constructor
	 */
	public CombatEpisodeComparator() {
		this( true );
	}

	/**
	 * @see gov.va.med.fw.util.DateComparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object arg1, Object arg2) {
		// Return -1 for episode1 < episode2. 1 for episode1 > episode2. 0 for equality
		int equal = 0;
		if( arg1 instanceof AbstractCombatEpisode && arg2 instanceof AbstractCombatEpisode ) {
            AbstractCombatEpisode episode1 = (AbstractCombatEpisode)arg1;
            AbstractCombatEpisode episode2 = (AbstractCombatEpisode)arg2;
			
			Date episode1_date = null;
			Date episode2_date = null;
			
			if( compareEndDate ) {
                episode1_date = ImpreciseDateUtils.getDateWithDefault( episode1.getEndDate() ); 
                episode2_date = ImpreciseDateUtils.getDateWithDefault( episode2.getEndDate() ); 
			}
			else {
                episode1_date = ImpreciseDateUtils.getDateWithDefault( episode1.getStartDate() ); 
                episode2_date = ImpreciseDateUtils.getDateWithDefault( episode2.getStartDate() ); 
			}

			// Compare the 2 episodes for the most recent
			if( episode1_date != null && episode2_date != null ) {
				equal = super.compare( episode1_date, episode2_date );
			} else {
                if(episode1_date == null && episode2_date == null) {
                    equal = 0;
                } else if(episode1_date == null) {
                    equal = -1;
                } else {
                    equal = 1;
                }
            }
		}
		return equal;
	}
}
