package gov.va.med.esr.common.util;

import java.util.Date;

import gov.va.med.esr.common.model.ee.Activation;
import gov.va.med.fw.util.DateComparator;

public class ActivationComparator extends DateComparator {
	/**
	 * An instance of compareEndDate
	 */
	private boolean compareEndDate = true;
	
	/**
	 * A default constructor
	 */
	public ActivationComparator( boolean compareEndDate ) {
		super();
		this.compareEndDate = compareEndDate;
	}

	/**
	 * A default constructor
	 */
	public ActivationComparator() {
		this( true );
	}

	/**
	 * @see gov.va.med.fw.util.DateComparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object arg1, Object arg2) {
		// Return -1 for activation1 < activation2. 1 for activation1 > activation2. 0 for equality
		int equal = 0;
		if (arg1 instanceof Activation && arg2 instanceof Activation) {
			Activation activation1 = (Activation)arg1;
			Activation activation2 = (Activation)arg2;
			
			Date activation1_date = null;
			Date activation2_date = null;
			
			if( compareEndDate ) {
				activation1_date = activation1.getActivationEndDate(); 
				activation2_date = activation2.getActivationEndDate(); 
			}
			else {
				activation1_date = activation1.getActivationBeginDate(); 
				activation2_date = activation2.getActivationBeginDate(); 
			}

			if( activation1_date != null && activation2_date != null ) {
				equal = super.compare( activation1_date, activation2_date );
			} else {
                if(activation1_date == null && activation2_date == null) {
                    equal = 0;
                } else if(activation1_date == null) {
                    equal = -1;
                } else {
                    equal = 1;
                }
            }
		}
		return equal;
	}
}
