/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.ui.form;

// Java Classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Calendar;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

/**
 * This is the form used in conjunction with the Financial Details pages.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class FinancialDetailsForm extends AbstractForm implements Serializable {

    private static final long    serialVersionUID = 480341561224445687L;

    private FinancialDetailsData financialsData   = null;
    private Person               person           = null;
    private boolean allowedToAddFinancials = true;
    private boolean allowedToEditFinancials = true;
    /* CR 9619, VFA-SP1 */
    private boolean allowedToUpdateNetWorth = true;
    
    private Boolean btFinancialInd = Boolean.TRUE;

    //inactive spouse data
    private List spouseFinacialsId;
    private List spouseSSN;
    private List spouseDisplaySSN;
    private List spouseRelationshipCode;
    private List spouseRelationship;
    private List spouseGenderCode;
    private List spouseGender;
    private List spouseName;    
    private List spouseValid;
    private List spouseInactiveDate;
    private List spouseLivedWithPatient;
    private List spouseContributedToSupport;
    private List spouseMarriageDate;
    private List spouseTotalIncome;
    private List spouseIncomeFromRanch;
    private List spouseOtherIncome;
    private List spouseEduExpenses;
    private List spouseCashAsset;
    private List spouseRealAsset;
    private List spouseOtherAsset;
    private List spouseStocksAsset;
    private List spouseUSCivilServiceIncome;
    private List spouseInterestDividentAnuityIncome;    
    private List spouseUnemploymentIncome; 
    private List spouseSocialSecurityIncome;
    private List spouseMilitaryRetirementIncome;
    private List spouseRailroadRetirementIncome;
    private List spouseOtherRetirementIncome;
    private List spouseWorkersCompIncome;
    private List spouseFinacialsHashCode;
    private List spouseDebt;
    private List spouseActive;
    private List contributedToSpousalSupport;
    
    
    
    /**
     * Default constructor.
     */
    public FinancialDetailsForm() {
        super();
        initialize();
    }

    /**
     * @return Returns the finData.
     */
    public FinancialDetailsData getFinancialsData() {
        return financialsData;
    }

    /**
     * @param finData
     *            The finData to set.
     */
    public void setFinancialsData(FinancialDetailsData finData) {
        this.financialsData = finData;
    }
    
    /**
     * @return Returns the allowedToAddFinancials.
     */
    public boolean getAllowedToAddFinancials() {
        return allowedToAddFinancials;
    }
    
    /**
     * @param allowedToAddFinancials The allowedToAddFinancials to set.
     */
    public void setAllowedToAddFinancials(boolean allowedToAddFinancials) {
        this.allowedToAddFinancials = allowedToAddFinancials;
    }
    
    /**
     * @return Returns the allowedToEditFinancials.
     */
    public boolean getAllowedToEditFinancials() {
        return allowedToEditFinancials;
    }
    
    /**
     * @param allowedToEditFinancials The allowedToEditFinancials to set.
     */
    public void setAllowedToEditFinancials(boolean allowedToEditFinancials) {
        this.allowedToEditFinancials = allowedToEditFinancials;
    }

	/**
	 * @return the allowedToUpdateNetWorth
	 */
	public boolean isAllowedToUpdateNetWorth() {
		return allowedToUpdateNetWorth;
	}

	/**
	 * @param allowedToUpdateNetWorth the allowedToUpdateNetWorth to set
	 */
	public void setAllowedToUpdateNetWorth(boolean allowedToUpdateNetWorth) {
		this.allowedToUpdateNetWorth = allowedToUpdateNetWorth;
	}

	// ***** REVISIT *****
    // We don't need Person in this form
    /**
     * @return Returns the person.
     */
    public Person getPerson() {
        return (Person) getVO();
    }

    /**
     * @see gov.va.med.fw.ui.struts.AbstractForm#createValueObject()
     */
    protected AbstractEntity createValueObject() {
        return new Person();
    }

    /**
     * @return Returns the post2005formatInd.
     */
    public boolean getPost2005formatInd() {
        return this.financialsData.getPost2005formatInd();
    }

    /**
     * @param post2005formatInd
     *            The post2005formatInd to set.
     */
    public void setPost2005formatInd(boolean post2005formatInd) {
        this.financialsData.setPost2005formatInd(post2005formatInd);
    }

    /**
     * @return this.financialsData.Returns the agreeToPayDeductible.
     */
    public String getAgreeToPayDeductible() {
        return this.financialsData.getAgreeToPayDeductible();
    }

    /**
     * @param agreeToPayDeductible
     *            The agreeToPayDeductible to set.
     */
    public void setAgreeToPayDeductible(String agreeToPayDeductible) {
        this.financialsData.setAgreeToPayDeductible(agreeToPayDeductible);
    }

    /**
     * @return this.financialsData.Returns the discloseFinIncome.
     */
    public String getDiscloseFinIncome() {
        return this.financialsData.getDiscloseFinIncome();
    }

    /**
     * @param discloseFinIncome
     *            The discloseFinIncome to set.
     */
    public void setDiscloseFinIncome(String discloseFinIncome) {
        this.financialsData.setDiscloseFinIncome(discloseFinIncome);
    }

    /**
     * @return this.financialsData.Returns the askAdjudicationQuestion.
     */
    public boolean getAskAdjudicationQuestion() {
        return this.financialsData.getAskAdjudicationQuestion();
    }

    /**
     * @param askAdjudicationQuestion
     *            The askAdjudicationQuestion to set.
     */
    public void setAskAdjudicationQuestion(boolean askAdjudicationQuestion) {
        this.financialsData.setAskAdjudicationQuestion(askAdjudicationQuestion);
    }

    /**
     * @return this.financialsData.Returns the sendForAdjudication.
     */
    public String getSendForAdjudication() {
        return this.financialsData.getSendForAdjudication();
    }

    /**
     * @param sendForAdjudication
     *            The sendForAdjudication to set.
     */
    public void setSendForAdjudication(String sendForAdjudication) {
        this.financialsData.setSendForAdjudication(sendForAdjudication);
    }

    /**
     * @return this.financialsData.Returns the incomeYear.
     */
    public String getIncomeYear() {
        return this.financialsData.getIncomeYear();
    }

    /**
     * @param incomeYear
     *            The incomeYear to set.
     */
    public void setIncomeYear(String incomeYear) {
        this.financialsData.setIncomeYear(incomeYear);
    }

    /**
     * @return this.financialsData.Returns the marriedLastCalendarYear.
     */
    public String getMarriedLastCalendarYear() {
        return this.financialsData.getMarriedLastCalendarYear();
    }

    /**
     * @param marriedLastCalendarYear
     *            The marriedLastCalendarYear to set.
     */
    public void setMarriedLastCalendarYear(String marriedLastCalendarYear) {
        this.financialsData.setMarriedLastCalendarYear(marriedLastCalendarYear);
    }

    /**
     * @return this.financialsData.Returns the testEffDate.
     */
    public String getTestEffDate() {
        return this.financialsData.getTestEffDate();
    }

    /**
     * @param testEffDate
     *            The testEffDate to set.
     */
    public void setTestEffDate(String testEffDate) {
        this.financialsData.setTestEffDate(testEffDate);
    }

    /**
     * @param person
     *            The person to set.
     */
    public void setPerson(Person person) {
        this.person = person;
    }

    /**
     * @return this.financialsData.Returns the isNewIncomeTest.
     */
    public boolean getNewIncomeTestInd() {
        return this.financialsData.getNewIncomeTestInd();
    }

    /**
     * @param isNewIncomeTest
     *            The isNewIncomeTest to set.
     */
    public void setNewIncomeTestInd(boolean isNewIncomeTest) {
        this.financialsData.setNewIncomeTestInd(isNewIncomeTest);
    }

    /**
     * @return this.financialsData.Returns the incomeTestAvaliableInd.
     */
    public boolean getIncomeTestAvaliableInd() {
        return this.financialsData.getIncomeTestAvaliableInd();
    }

    /**
     * @param incomeTestAvaliableInd
     *            The incomeTestAvaliableInd to set.
     */
    public void setIncomeTestAvaliableInd(boolean incomeTestAvaliableInd) {
        this.financialsData.setIncomeTestAvaliableInd(incomeTestAvaliableInd);
    }
    /**
     * @return Returns the sourceOfTest.
     */
    public String getSourceOfTest() {
        return this.financialsData.getSourceOfTest();
    }
    /**
     * @param sourceOfTest The sourceOfTest to set.
     */
    public void setSourceOfTest(String sourceOfTest) {
        this.financialsData.setSourceOfTest(sourceOfTest);
    }
    
    /**
     * @return this.financialsData.Returns the cashAndBankAccountAsset.
     */
    public String getCashAndBankAccountAsset() {
        return this.financialsData.getCashAndBankAccountAsset();
    }

    /**
     * @param cashAndBankAccountAsset
     *            The cashAndBankAccountAsset to set.
     */
    public void setCashAndBankAccountAsset(String cashAndBankAccountAsset) {
        this.financialsData.setCashAndBankAccountAsset(cashAndBankAccountAsset);
    }

    /**
     * @return this.financialsData.Returns the adjustedMedicalExpense.
     */
    public String getAdjustedMedicalExpense() {
        return this.financialsData.getAdjustedMedicalExpense();
    }

    /**
     * @param adjustedMedicalExpense
     *            The adjustedMedicalExpense to set.
     */
    public void setAdjustedMedicalExpense(String adjustedMedicalExpense) {
        this.financialsData.setAdjustedMedicalExpense(adjustedMedicalExpense);
    }

    /**
     * @return this.financialsData.Returns the dependentInfoList.
     */
    public List getDependentInfoList() {
        return this.financialsData.getDependentInfoList();
    }

    /**
     * @param dependentInfoList
     *            The dependentInfoList to set.
     */
    public void setDependentInfoList(List dependentInfoList) {
        this.financialsData.setDependentInfoList(dependentInfoList);
    }

    /**
     * @return this.financialsData.Returns the educationExpense.
     */
    public String getEducationExpense() {
        return this.financialsData.getEducationExpense();
    }

    /**
     * @param educationExpense
     *            The educationExpense to set.
     */
    public void setEducationExpense(String educationExpense) {
        this.financialsData.setEducationExpense(educationExpense);
    }

    /**
     * @return this.financialsData.Returns the netIncomeFromFarmRanchOrBusiness.
     */
    public String getNetIncomeFromFarmRanchOrBusiness() {
        return this.financialsData.getNetIncomeFromFarmRanchOrBusiness();
    }

    /**
     * @param netIncomeFromFarmRanchOrBusiness
     *            The netIncomeFromFarmRanchOrBusiness to set.
     */
    public void setNetIncomeFromFarmRanchOrBusiness(String netIncomeFromFarmRanchOrBusiness) {
        this.financialsData.setNetIncomeFromFarmRanchOrBusiness(netIncomeFromFarmRanchOrBusiness);
    }

    /**
     * @return this.financialsData.Returns the otherIncome.
     */
    public String getOtherIncome() {
        return this.financialsData.getOtherIncome();
    }

    /**
     * @param otherIncome
     *            The otherIncome to set.
     */
    public void setOtherIncome(String otherIncome) {
        this.financialsData.setOtherIncome(otherIncome);
    }

    /**
     * @return this.financialsData.Returns the otherPropertyAsset.
     */
    public String getOtherPropertyAsset() {
        return this.financialsData.getOtherPropertyAsset();
    }

    /**
     * @param otherPropertyAsset
     *            The otherPropertyAsset to set.
     */
    public void setOtherPropertyAsset(String otherPropertyAsset) {
        this.financialsData.setOtherPropertyAsset(otherPropertyAsset);
    }

    /**
     * @return this.financialsData.Returns the realPropertyAsset.
     */
    public String getRealPropertyAsset() {
        return this.financialsData.getRealPropertyAsset();
    }

    /**
     * @param realPropertyAsset
     *            The realPropertyAsset to set.
     */
    public void setRealPropertyAsset(String realPropertyAsset) {
        this.financialsData.setRealPropertyAsset(realPropertyAsset);
    }

    /**
     * @return this.financialsData.Returns the stocksAsset.
     */
    public String getStocksAsset() {
        return this.financialsData.getStocksAsset();
    }

    /**
     * @param stocksAsset
     *            The stocksAsset to set.
     */
    public void setStocksAsset(String stocksAsset) {
        this.financialsData.setStocksAsset(stocksAsset);
    }

    /**
     * @return this.financialsData.Returns the debt.
     */
    public String getDebt() {
        return this.financialsData.getDebt();
    }

    /**
     * @param debt
     *            The debt to set.
     */
    public void setDebt(String debt) {
        this.financialsData.setDebt(debt);
    }

    /**
     * @return this.financialsData.Returns the interestDividentAnuityIncome.
     */
    public String getInterestDividentAnuityIncome() {
        return this.financialsData.getInterestDividentAnuityIncome();
    }

    /**
     * @param interestDividentAnuityIncome
     *            The interestDividentAnuityIncome to set.
     */
    public void setInterestDividentAnuityIncome(String interestDividentAnuityIncome) {
        this.financialsData.setInterestDividentAnuityIncome(interestDividentAnuityIncome);
    }

    /**
     * @return this.financialsData.Returns the militaryRetirementIncome.
     */
    public String getMilitaryRetirementIncome() {
        return this.financialsData.getMilitaryRetirementIncome();
    }

    /**
     * @param militaryRetirementIncome
     *            The militaryRetirementIncome to set.
     */
    public void setMilitaryRetirementIncome(String militaryRetirementIncome) {
        this.financialsData.setMilitaryRetirementIncome(militaryRetirementIncome);
    }

    /**
     * @return this.financialsData.Returns the otherRetirementIncome.
     */
    public String getOtherRetirementIncome() {
        return this.financialsData.getOtherRetirementIncome();
    }

    /**
     * @param otherRetirementIncome
     *            The otherRetirementIncome to set.
     */
    public void setOtherRetirementIncome(String otherRetirementIncome) {
        this.financialsData.setOtherRetirementIncome(otherRetirementIncome);
    }

    /**
     * @return this.financialsData.Returns the railroadRetirementIncome.
     */
    public String getRailroadRetirementIncome() {
        return this.financialsData.getRailroadRetirementIncome();
    }

    /**
     * @param railroadRetirementIncome
     *            The railroadRetirementIncome to set.
     */
    public void setRailroadRetirementIncome(String railroadRetirementIncome) {
        this.financialsData.setRailroadRetirementIncome(railroadRetirementIncome);
    }

    /**
     * @return this.financialsData.Returns the socialSecurityIncome.
     */
    public String getSocialSecurityIncome() {
        return this.financialsData.getSocialSecurityIncome();
    }

    /**
     * @param socialSecurityIncome
     *            The socialSecurityIncome to set.
     */
    public void setSocialSecurityIncome(String socialSecurityIncome) {
        this.financialsData.setSocialSecurityIncome(socialSecurityIncome);
    }

    /**
     * @return this.financialsData.Returns the unemploymentIncome.
     */
    public String getUnemploymentIncome() {
        return this.financialsData.getUnemploymentIncome();
    }

    /**
     * @param unemploymentIncome
     *            The unemploymentIncome to set.
     */
    public void setUnemploymentIncome(String unemploymentIncome) {
        this.financialsData.setUnemploymentIncome(unemploymentIncome);
    }

    /**
     * @return this.financialsData.Returns the uSCivilServiceIncome.
     */
    public String getUSCivilServiceIncome() {
        return this.financialsData.getUSCivilServiceIncome();
    }

    /**
     * @param civilServiceIncome
     *            The uSCivilServiceIncome to set.
     */
    public void setUSCivilServiceIncome(String civilServiceIncome) {
        this.financialsData.setUSCivilServiceIncome(civilServiceIncome);
    }

    /**
     * @return this.financialsData.Returns the workersCompIncome.
     */
    public String getWorkersCompIncome() {
        return this.financialsData.getWorkersCompIncome();
    }

    /**
     * @param workersCompIncome
     *            The workersCompIncome to set.
     */
    public void setWorkersCompIncome(String workersCompIncome) {
        this.financialsData.setWorkersCompIncome(workersCompIncome);
    }

    /**
     * @return this.financialsData.Returns the spouseInfo.
     */
    public SpouseFinancialInfoBean getSpouseInfo() {
        return this.financialsData.getSpouseInfo();
    }

    /**
     * @param spouseInfo
     *            The spouseInfo to set.
     */
    public void setSpouseInfo(SpouseFinancialInfoBean spouseInfo) {
        this.financialsData.setSpouseInfo(spouseInfo);
    }

    /**
     * @return this.financialsData.Returns the totalIncome.
     */
    public String getTotalEmploymentIncome() {
        return this.financialsData.getTotalEmploymentIncome();
    }

    /**
     * @param totalIncome
     *            The totalIncome to set.
     */
    public void setTotalEmploymentIncome(String totalIncome) {
        this.financialsData.setTotalEmploymentIncome(totalIncome);
    }

    /**
     * @return this.financialsData.Returns the name.
     */
    public String getName() {
        return this.financialsData.getName();
    }

    /**
     * @param name
     *            The name to set.
     */
    public void setName(String name) {
        this.financialsData.setName(name);
    }

    /**
     * @return this.financialsData.Returns the funeralBurialExpense.
     */
    public String getFuneralBurialExpense() {
        return this.financialsData.getFuneralBurialExpense();
    }

    /**
     * @param funeralBurialExpense
     *            The funeralBurialExpense to set.
     */
    public void setFuneralBurialExpense(String funeralBurialExpense) {
        this.financialsData.setFuneralBurialExpense(funeralBurialExpense);
    }

    /**
     * @return this.financialsData.Returns the nonReimbMedicalExpense.
     */
    public String getNonReimbMedicalExpense() {
        return this.financialsData.getNonReimbMedicalExpense();
    }

    /**
     * @param nonReimbMedicalExpense
     *            The nonReimbMedicalExpense to set.
     */
    public void setNonReimbMedicalExpense(String nonReimbMedicalExpense) {
        this.financialsData.setNonReimbMedicalExpense(nonReimbMedicalExpense);
    }

    /**
     * @return this.financialsData.Returns the displayName.
     */
    public String getDisplayName() {
        return this.financialsData.getDisplayName();
    }

    /**
     * @param displayName
     *            The displayName to set.
     */
    public void setDisplayName(String displayName) {
        this.financialsData.setDisplayName(displayName);
    }

    // Dependent data

    /**
     * @return this.financialsData.Returns the depAmtContributed.
     */
    public String getDepSSN(int index) {
        return this.financialsData.getDepSSN(index);
    }

    /**
     * @param depAmtContributed
     *            The depAmtContributed to set.
     */
    public void setDepSSN(int index, String ssn) {
        this.financialsData.setDepSSN(index, ssn);
    }

    /**
     * @return the depRelationshipCode
     */
    public String getDepRelationshipCode(int index) {
        return this.financialsData.getDepRelationshipCode(index);
    }

    /**
     * @param depRelationshipCode
     *            The depRelationshipCode to set.
     */
    public void setDepRelationshipCode(int index, String relationshipCode) {
        this.financialsData.setDepRelationshipCode(index, relationshipCode);
    }

    /**
     * @return the depRelationship.
     */
    public String getDepRelationship(int index) {
        return this.financialsData.getDepRelationship(index);
    }

    /**
     * @param depRelationship
     *            The depRelationship to set.
     */
    public void setDepRelationship(int index, String relationship) {
        this.financialsData.setDepRelationship(index, relationship);
    }

    /**
     * @return depGenderCode
     */
    public String getDepGenderCode(int index) {
        return this.financialsData.getDepGenderCode(index);
    }

    /**
     * @param depGenderCode - The gender to set.
     */
    public void setDepGenderCode(int index, String gender) {
        this.financialsData.setDepGenderCode(index, gender);
    }

    /**
     * @return depGender
     */
    public String getDepGender(int index) {
        return this.financialsData.getDepGender(index);
    }

    /**
     * @param depGender - The gender to set.
     */
    public void setDepGender(int index, String gender) {
        this.financialsData.setDepGender(index, gender);
    }

    /**
     * @return this.financialsData.Returns the depAmtContributed.
     */
    public String getDepAmtContributed(int index) {
        return this.financialsData.getDepAmtContributed(index);
    }

    /**
     * @param depAmtContributed
     *            The depAmtContributed to set.
     */
    public void setDepAmtContributed(int index, String depAmtContributed) {
        this.financialsData.setDepAmtContributed(index, depAmtContributed);
    }

    /**
     * @return this.financialsData.Returns the depAttendedSchool.
     */
    public String getDepAttendedSchool(int index) {
        return this.financialsData.getDepAttendedSchool(index);
    }

    /**
     * @param depAttendedSchool
     *            The depAttendedSchool to set.
     */
    public void setDepAttendedSchool(int index, String depAttendedSchool) {
        this.financialsData.setDepAttendedSchool(index, depAttendedSchool);
    }

    /**
     * @return this.financialsData.Returns the depCashAsset.
     */
    public String getDepCashAsset(int index) {
        return this.financialsData.getDepCashAsset(index);
    }

    /**
     * @param depCashAsset
     *            The depCashAsset to set.
     */
    public void setDepCashAsset(int index, String depCashAsset) {
        this.financialsData.setDepCashAsset(index, depCashAsset);
    }

    /**
     * @return this.financialsData.Returns the depContributedToSupport.
     */
    public String getDepContributedToSupport(int index) {
        return this.financialsData.getDepContributedToSupport(index);
    }

    /**
     * @param depContributedToSupport
     *            The depContributedToSupport to set.
     */
    public void setDepContributedToSupport(int index, String depContributedToSupport) {
        this.financialsData.setDepContributedToSupport(index, depContributedToSupport);
    }

    /**
     * @return this.financialsData.Returns the depDebts.
     */
    public String getDepStocksAsset(int index) {
        return this.financialsData.getDepStocksAsset(index);
    }

    /**
     * @param depStocks
     *            The depStocks to set.
     */
    public void setDepStocksAsset(int index, String depStocksAsset) {
        this.financialsData.setDepStocksAsset(index, depStocksAsset);
    }

    /**
     * @return this.financialsData.Returns the depDisplayName.
     */
    public String getDepName(int index) {
        return this.financialsData.getDepName(index);
    }

    /**
     * @param depDisplayName
     *            The depDisplayName to set.
     */
    public void setDepName(int index, String depDisplayName) {
        this.financialsData.setDepName(index, depDisplayName);
    }

    /**
     * @return this.financialsData.Returns the depEduExpenses.
     */
    public String getDepEduExpenses(int index) {
        return this.financialsData.getDepEduExpenses(index);
    }

    /**
     * @param depEduExpenses
     *            The depEduExpenses to set.
     */
    public void setDepEduExpenses(int index, String depEduExpenses) {
        this.financialsData.setDepEduExpenses(index, depEduExpenses);
    }

    /**
     * @return this.financialsData.Returns the depEffectiveDate.
     */
    public String getDepEffectiveDate(int index) {
        return this.financialsData.getDepEffectiveDate(index);
    }

    /**
     * @param depEffectiveDate
     *            The depEffectiveDate to set.
     */
    public void setDepEffectiveDate(int index, String depEffectiveDate) {
        this.financialsData.setDepEffectiveDate(index, depEffectiveDate);
    }

    /**
     * @return this.financialsData.Returns the depFinacialsId.
     */
    public String getDepFinacialsId(int index) {
        return this.financialsData.getDepFinacialsId(index);
    }

    /**
     * @param depFinacialsId
     *            The depFinacialsId to set.
     */
    public void setDepFinacialsId(int index, String depFinacialsId) {
        this.financialsData.setDepFinacialsId(index, depFinacialsId);
    }

    /**
     * @return this.financialsData.Returns the depHasIncome.
     */
    public String getDepHasIncome(int index) {
        return this.financialsData.getDepHasIncome(index);
    }

    /**
     * @param depHasIncome
     *            The depHasIncome to set.
     */
    public void setDepHasIncome(int index, String depHasIncome) {
        this.financialsData.setDepHasIncome(index, depHasIncome);
    }

    /**
     * @return this.financialsData.Returns the depInactiveDate.
     */
    public String getDepInactiveDate(int index) {
        return this.financialsData.getDepInactiveDate(index);
    }

    /**
     * @param depInactiveDate
     *            The depInactiveDate to set.
     */
    public void setDepInactiveDate(int index, String depInactiveDate) {
        this.financialsData.setDepInactiveDate(index, depInactiveDate);
    }

    /**
     * @return this.financialsData.Returns the depIncapableOfSelfSupport.
     */
    public String getDepIncapableOfSelfSupport(int index) {
        return this.financialsData.getDepIncapableOfSelfSupport(index);
    }

    /**
     * @param depIncapableOfSelfSupport
     *            The depIncapableOfSelfSupport to set.
     */
    public void setDepIncapableOfSelfSupport(int index, String depIncapableOfSelfSupport) {
        this.financialsData.setDepIncapableOfSelfSupport(index, depIncapableOfSelfSupport);
    }

    /**
     * @return this.financialsData.Returns the depIncomeAvailableToPatient.
     */
    public String getDepIncomeAvailableToPatient(int index) {
        return this.financialsData.getDepIncomeAvailableToPatient(index);
    }

    /**
     * @param depIncomeAvailableToPatient
     *            The depIncomeAvailableToPatient to set.
     */
    public void setDepIncomeAvailableToPatient(int index, String depIncomeAvailableToPatient) {
        this.financialsData.setDepIncomeAvailableToPatient(index, depIncomeAvailableToPatient);
    }

    /**
     * @return this.financialsData.Returns the depIncomeFromRanch.
     */
    public String getDepIncomeFromRanch(int index) {
        return this.financialsData.getDepIncomeFromRanch(index);
    }

    /**
     * @param depIncomeFromRanch
     *            The depIncomeFromRanch to set.
     */
    public void setDepIncomeFromRanch(int index, String depIncomeFromRanch) {
        this.financialsData.setDepIncomeFromRanch(index, depIncomeFromRanch);
    }

    /**
     * @return this.financialsData.Returns the depLivedWithPatient.
     */
    public String getDepLivedWithPatient(int index) {
        return this.financialsData.getDepLivedWithPatient(index);
    }

    /**
     * @param depLivedWithPatient
     *            The depLivedWithPatient to set.
     */
    public void setDepLivedWithPatient(int index, String depLivedWithPatient) {
        this.financialsData.setDepLivedWithPatient(index, depLivedWithPatient);
    }

    /**
     * @return this.financialsData.Returns the depOtherAsset.
     */
    public String getDepOtherAsset(int index) {
        return this.financialsData.getDepOtherAsset(index);
    }

    /**
     * @param depOtherAsset
     *            The depOtherAsset to set.
     */
    public void setDepOtherAsset(int index, String depOtherAsset) {
        this.financialsData.setDepOtherAsset(index, depOtherAsset);
    }

    /**
     * @return this.financialsData.Returns the depOtherIncome.
     */
    public String getDepOtherIncome(int index) {
        return this.financialsData.getDepOtherIncome(index);
    }

    /**
     * @param depOtherIncome
     *            The depOtherIncome to set.
     */
    public void setDepOtherIncome(int index, String depOtherIncome) {
        this.financialsData.setDepOtherIncome(index, depOtherIncome);
    }

    /**
     * @return this.financialsData.Returns the depRealAsset.
     */
    public String getDepRealAsset(int index) {
        return this.financialsData.getDepRealAsset(index);
    }

    /**
     * @param depRealAsset
     *            The depRealAsset to set.
     */
    public void setDepRealAsset(int index, String depRealAsset) {
        this.financialsData.setDepRealAsset(index, depRealAsset);
    }

    /**
     * @return this.financialsData.Returns the depTotalIncome.
     */
    public String getDepTotalIncome(int index) {
        return this.financialsData.getDepTotalIncome(index);
    }

    /**
     * @param depTotalIncome
     *            The depTotalIncome to set.
     */
    public void setDepTotalIncome(int index, String depTotalIncome) {
        this.financialsData.setDepTotalIncome(index, depTotalIncome);
    }

    /**
     * @return this.financialsData.Returns the depValid.
     */
    public String getDepValid(int index) {
        return this.financialsData.getDepValid(index);
    }

    /**
     * @param depValid
     *            The depValid to set.
     */
    public void setDepValid(int index, String depValid) {
        this.financialsData.setDepValid(index, depValid);
    }

    /**
     * @return this.financialsData.Returns the depInterestDividentAnuityIncome.
     */
    public String getDepInterestDividentAnuityIncome(int index) {
        return this.financialsData.getDepInterestDividentAnuityIncome(index);
    }

    /**
     * @param depInterestDividentAnuityIncome
     *            The depInterestDividentAnuityIncome to set.
     */
    public void setDepInterestDividentAnuityIncome(int index, String depInterestDividentAnuityIncome) {
        this.financialsData.setDepInterestDividentAnuityIncome(index,
                depInterestDividentAnuityIncome);
    }

    /**
     * @return this.financialsData.Returns the depMilitaryRetirementIncome.
     */
    public String getDepMilitaryRetirementIncome(int index) {
        return this.financialsData.getDepMilitaryRetirementIncome(index);
    }

    /**
     * @param depMilitaryRetirementIncome
     *            The depMilitaryRetirementIncome to set.
     */
    public void setDepMilitaryRetirementIncome(int index, String depMilitaryRetirementIncome) {
        this.financialsData.setDepMilitaryRetirementIncome(index, depMilitaryRetirementIncome);
    }

    /**
     * @return this.financialsData.Returns the depOtherRetirementIncome.
     */
    public String getDepOtherRetirementIncome(int index) {
        return this.financialsData.getDepOtherRetirementIncome(index);
    }

    /**
     * @param depOtherRetirementIncome
     *            The depOtherRetirementIncome to set.
     */
    public void setDepOtherRetirementIncome(int index, String depOtherRetirementIncome) {
        this.financialsData.setDepOtherRetirementIncome(index, depOtherRetirementIncome);
    }

    /**
     * @return this.financialsData.Returns the depRailroadRetirementIncome.
     */
    public String getDepRailroadRetirementIncome(int index) {
        return this.financialsData.getDepRailroadRetirementIncome(index);
    }

    /**
     * @param depRailroadRetirementIncome
     *            The depRailroadRetirementIncome to set.
     */
    public void setDepRailroadRetirementIncome(int index, String depRailroadRetirementIncome) {
        this.financialsData.setDepRailroadRetirementIncome(index, depRailroadRetirementIncome);
    }

    /**
     * @return this.financialsData.Returns the depSocialSecurityIncome.
     */
    public String getDepSocialSecurityIncome(int index) {
        return this.financialsData.getDepSocialSecurityIncome(index);
    }

    /**
     * @param depSocialSecurityIncome
     *            The depSocialSecurityIncome to set.
     */
    public void setDepSocialSecurityIncome(int index, String depSocialSecurityIncome) {
        this.financialsData.setDepSocialSecurityIncome(index, depSocialSecurityIncome);
    }

    /**
     * @return this.financialsData.Returns the depUnemploymentIncome.
     */
    public String getDepUnemploymentIncome(int index) {
        return this.financialsData.getDepUnemploymentIncome(index);
    }

    /**
     * @param depUnemploymentIncome
     *            The depUnemploymentIncome to set.
     */
    public void setDepUnemploymentIncome(int index, String depUnemploymentIncome) {
        this.financialsData.setDepUnemploymentIncome(index, depUnemploymentIncome);
    }

    /**
     * @return this.financialsData.Returns the depUSCivilServiceIncome.
     */
    public String getDepUSCivilServiceIncome(int index) {
        return this.financialsData.getDepUSCivilServiceIncome(index);
    }

    /**
     * @param depUSCivilServiceIncome
     *            The depUSCivilServiceIncome to set.
     */
    public void setDepUSCivilServiceIncome(int index, String depUSCivilServiceIncome) {
        this.financialsData.setDepUSCivilServiceIncome(index, depUSCivilServiceIncome);
    }

    /**
     * @return this.financialsData.Returns the depWorkersCompIncome.
     */
    public String getDepWorkersCompIncome(int index) {
        return this.financialsData.getDepWorkersCompIncome(index);
    }

    /**
     * @param depWorkersCompIncome
     *            The depWorkersCompIncome to set.
     */
    public void setDepWorkersCompIncome(int index, String depWorkersCompIncome) {
        this.financialsData.setDepWorkersCompIncome(index, depWorkersCompIncome);
    }

    /**
     * @return this.financialsData.Returns the depDisplaySSN.
     */
    public String getDepDisplaySSN(int index) {
        return this.financialsData.getDepDisplaySSN(index);
    }

    /**
     * @param depDisplaySSN
     *            The depDisplaySSN to set.
     */
    public void setDepDisplaySSN(int index, String depDisplaySSN) {
        this.financialsData.setDepDisplaySSN(index, depDisplaySSN);
    }

    /**
     * @return this.financialsData.Returns the depAmtContribu =
     */
    public List getDepAmtContributedList() {
        return this.financialsData.getDepAmtContributedList();
    }

    /**
     * @param depAmtContributedList
     *            The depAmtContributedList to set.
     */
    public void setDepAmtContributedList(List depAmtContributedList) {
        this.financialsData.setDepAmtContributedList(depAmtContributedList);
    }

    /**
     * @return this.financialsData.Returns the depAttendedSchoolList.
     */
    public List getDepAttendedSchoolList() {
        return this.financialsData.getDepAttendedSchoolList();
    }

    /**
     * @param depAttendedSchoolList
     *            The depAttendedSchoolList to set.
     */
    public void setDepAttendedSchoolList(List depAttendedSchoolList) {
        this.financialsData.setDepAttendedSchoolList(depAttendedSchoolList);
    }

    /**
     * @return this.financialsData.Returns the depCashAssetList.
     */
    public List getDepCashAssetList() {
        return this.financialsData.getDepCashAssetList();
    }

    /**
     * @param depCashAssetList
     *            The depCashAssetList to set.
     */
    public void setDepCashAssetList(List depCashAssetList) {
        this.financialsData.setDepCashAssetList(depCashAssetList);
    }

    /**
     * @return this.financialsData.Returns the depContributedToSupportList.
     */
    public List getDepContributedToSupportList() {
        return this.financialsData.getDepContributedToSupportList();
    }

    /**
     * @param depContributedToSupportList
     *            The depContributedToSupportList to set.
     */
    public void setDepContributedToSupportList(List depContributedToSupportList) {
        this.financialsData.setDepContributedToSupportList(depContributedToSupportList);
    }

    /**
     * @return this.financialsData.Returns the depDebtsList.
     */
    public List getDepStocksAssetList() {
        return this.financialsData.getDepStocksAssetList();
    }

    /**
     * @param depStocksAssetList
     *            The depStocksAssetList to set.
     */
    public void setDepStocksAssetList(List depStocksList) {
        this.financialsData.setDepStocksAssetList(depStocksList);
    }

    /**
     * @return this.financialsData.Returns the depNameList.
     */
    public List getDepNameList() {
        return this.financialsData.getDepNameList();
    }

    /**
     * @param depDisplayNameList
     *            The depDisplayNameList to set.
     */
    public void setDepNameList(List depDisplayNameList) {
        this.financialsData.setDepNameList(depDisplayNameList);
    }

    /**
     * @return this.financialsData.Returns the depEduExpensesList.
     */
    public List getDepEduExpensesList() {
        return this.financialsData.getDepEduExpensesList();
    }

    /**
     * @param depEduExpensesList
     *            The depEduExpensesList to set.
     */
    public void setDepEduExpensesList(List depEduExpensesList) {
        this.financialsData.setDepEduExpensesList(depEduExpensesList);
    }

    /**
     * @return this.financialsData.Returns the depEffectiveDateList.
     */
    public List getDepEffectiveDateList() {
        return this.financialsData.getDepEffectiveDateList();
    }

    /**
     * @param depEffectiveDateList
     *            The depEffectiveDateList to set.
     */
    public void setDepEffectiveDateList(List depEffectiveDateList) {
        this.financialsData.setDepEffectiveDateList(depEffectiveDateList);
    }

    /**
     * @return this.financialsData.Returns the depFinacialsIdList.
     */
    public List getDepFinacialsIdList() {
        return this.financialsData.getDepFinacialsIdList();
    }

    /**
     * @param depFinacialsIdList
     *            The depFinacialsIdList to set.
     */
    public void setDepFinacialsIdList(List depFinacialsIdList) {
        this.financialsData.setDepFinacialsIdList(depFinacialsIdList);
    }

    /**
     * @return this.financialsData.Returns the depHasIncomeList.
     */
    public List getDepHasIncomeList() {
        return this.financialsData.getDepHasIncomeList();
    }

    /**
     * @param depHasIncomeList
     *            The depHasIncomeList to set.
     */
    public void setDepHasIncomeList(List depHasIncomeList) {
        this.financialsData.setDepHasIncomeList(depHasIncomeList);
    }

    /**
     * @return this.financialsData.Returns the depInactiveDateList.
     */
    public List getDepInactiveDateList() {
        return this.financialsData.getDepInactiveDateList();
    }

    /**
     * @param depInactiveDateList
     *            The depInactiveDateList to set.
     */
    public void setDepInactiveDateList(List depInactiveDateList) {
        this.financialsData.setDepInactiveDateList(depInactiveDateList);
    }

    /**
     * @return this.financialsData.Returns the depIncapableOfSelfSupportList.
     */
    public List getDepIncapableOfSelfSupportList() {
        return this.financialsData.getDepIncapableOfSelfSupportList();
    }

    /**
     * @param depIncapableOfSelfSupportList
     *            The depIncapableOfSelfSupportList to set.
     */
    public void setDepIncapableOfSelfSupportList(List depIncapableOfSelfSupportList) {
        this.financialsData.setDepIncapableOfSelfSupportList(depIncapableOfSelfSupportList);
    }

    /**
     * @return this.financialsData.Returns the depIncomeAvailableToPatientList.
     */
    public List getDepIncomeAvailableToPatientList() {
        return this.financialsData.getDepIncomeAvailableToPatientList();
    }

    /**
     * @param depIncomeAvailableToPatientList
     *            The depIncomeAvailableToPatientList to set.
     */
    public void setDepIncomeAvailableToPatientList(List depIncomeAvailableToPatientList) {
        this.financialsData.setDepIncomeAvailableToPatientList(depIncomeAvailableToPatientList);
    }

    /**
     * @return this.financialsData.Returns the depIncomeFromRanchList.
     */
    public List getDepIncomeFromRanchList() {
        return this.financialsData.getDepIncomeFromRanchList();
    }

    /**
     * @param depIncomeFromRanchList
     *            The depIncomeFromRanchList to set.
     */
    public void setDepIncomeFromRanchList(List depIncomeFromRanchList) {
        this.financialsData.setDepIncomeFromRanchList(depIncomeFromRanchList);
    }

    /**
     * @return this.financialsData.Returns the depLivedWithPatientList.
     */
    public List getDepLivedWithPatientList() {
        return this.financialsData.getDepLivedWithPatientList();
    }

    /**
     * @param depLivedWithPatientList
     *            The depLivedWithPatientList to set.
     */
    public void setDepLivedWithPatientList(List depLivedWithPatientList) {
        this.financialsData.setDepLivedWithPatientList(depLivedWithPatientList);
    }

    /**
     * @return this.financialsData.Returns the depOtherAssetList.
     */
    public List getDepOtherAssetList() {
        return this.financialsData.getDepOtherAssetList();
    }

    /**
     * @param depOtherAssetList
     *            The depOtherAssetList to set.
     */
    public void setDepOtherAssetList(List depOtherAssetList) {
        this.financialsData.setDepOtherAssetList(depOtherAssetList);
    }

    /**
     * @return this.financialsData.Returns the depOtherIncomeList.
     */
    public List getDepOtherIncomeList() {
        return this.financialsData.getDepOtherIncomeList();
    }

    /**
     * @param depOtherIncomeList
     *            The depOtherIncomeList to set.
     */
    public void setDepOtherIncomeList(List depOtherIncomeList) {
        this.financialsData.setDepOtherIncomeList(depOtherIncomeList);
    }

    /**
     * @return this.financialsData.Returns the depRealAssetList.
     */
    public List getDepRealAssetList() {
        return this.financialsData.getDepRealAssetList();
    }

    /**
     * @param depRealAssetList
     *            The depRealAssetList to set.
     */
    public void setDepRealAssetList(List depRealAssetList) {
        this.financialsData.setDepRealAssetList(depRealAssetList);
    }

    /**
     * @return this.financialsData.Returns the depTotalIncomeList.
     */
    public List getDepTotalIncomeList() {
        return this.financialsData.getDepTotalIncomeList();
    }

    /**
     * @param depTotalIncomeList
     *            The depTotalIncomeList to set.
     */
    public void setDepTotalIncomeList(List depTotalIncomeList) {
        this.financialsData.setDepTotalIncomeList(depTotalIncomeList);
    }

    /**
     * @return this.financialsData.Returns the depValidList.
     */
    public List getDepValidList() {
        return this.financialsData.getDepValidList();
    }

    /**
     * @param depValidList
     *            The depValidList to set.
     */
    public void setDepValidList(List depValidList) {
        this.financialsData.setDepValidList(depValidList);
    }

    /**
     * @return this.financialsData.Returns the depRelationshipList.
     */
    public List getDepRelationshipList() {
        return this.financialsData.getDepRelationshipList();
    }

    /**
     * @param depRelationshipList
     *            The depRelationshipList to set.
     */
    public void setDepRelationshipList(List depRelationshipList) {
        this.financialsData.setDepRelationshipList(depRelationshipList);
    }

    /**
     * @return this.financialsData.Returns the depGenderList.
     */
    public List getDepGenderList() {
        return this.financialsData.getDepGenderList();
    }

    /**
     * @param depGenderList
     *            The depGenderList to set.
     */
    public void setDepGenderList(List depGenderList) {
        this.financialsData.setDepGenderList(depGenderList);
    }
    /**
     * @return this.financialsData.Returns the depSSNList.
     */
    public List getDepSSNList() {
        return this.financialsData.getDepSSNList();
    }

    /**
     * @param depSSNList
     *            The depSSNList to set.
     */
    public void setDepSSNList(List depSSNList) {
        this.financialsData.setDepSSNList(depSSNList);
    }

    /**
     * @return this.financialsData.Returns the depInterestDividentAnuityIncome.
     */
    public List getDepInterestDividentAnuityIncomeList() {
        return this.financialsData.getDepInterestDividentAnuityIncomeList();
    }

    /**
     * @param depInterestDividentAnuityIncome
     *            The depInterestDividentAnuityIncome to set.
     */
    public void setDepInterestDividentAnuityIncomeList(List depInterestDividentAnuityIncome) {
        this.financialsData.setDepInterestDividentAnuityIncomeList(depInterestDividentAnuityIncome);
    }

    /**
     * @return this.financialsData.Returns the depMilitaryRetirementIncome.
     */
    public List getDepMilitaryRetirementIncomeList() {
        return this.financialsData.getDepMilitaryRetirementIncomeList();
    }

    /**
     * @param depMilitaryRetirementIncome
     *            The depMilitaryRetirementIncome to set.
     */
    public void setDepMilitaryRetirementIncomeList(List depMilitaryRetirementIncome) {
        this.financialsData.setDepMilitaryRetirementIncomeList(depMilitaryRetirementIncome);
    }

    /**
     * @return this.financialsData.Returns the depOtherRetirementIncome.
     */
    public List getDepOtherRetirementIncomeList() {
        return this.financialsData.getDepOtherRetirementIncomeList();
    }

    /**
     * @param depOtherRetirementIncome
     *            The depOtherRetirementIncome to set.
     */
    public void setDepOtherRetirementIncomeList(List depOtherRetirementIncome) {
        this.financialsData.setDepOtherRetirementIncomeList(depOtherRetirementIncome);
    }

    /**
     * @return this.financialsData.Returns the depRailroadRetirementIncome.
     */
    public List getDepRailroadRetirementIncomeList() {
        return this.financialsData.getDepRailroadRetirementIncomeList();
    }

    /**
     * @param depRailroadRetirementIncome
     *            The depRailroadRetirementIncome to set.
     */
    public void setDepRailroadRetirementIncomeList(List depRailroadRetirementIncome) {
        this.financialsData.setDepRailroadRetirementIncomeList(depRailroadRetirementIncome);
    }

    /**
     * @return this.financialsData.Returns the depSocialSecurityIncome.
     */
    public List getDepSocialSecurityIncomeList() {
        return this.financialsData.getDepSocialSecurityIncomeList();
    }

    /**
     * @param depSocialSecurityIncome
     *            The depSocialSecurityIncome to set.
     */
    public void setDepSocialSecurityIncomeList(List depSocialSecurityIncome) {
        this.financialsData.setDepSocialSecurityIncomeList(depSocialSecurityIncome);
    }

    /**
     * @return this.financialsData.Returns the depUnemploymentIncome.
     */
    public List getDepUnemploymentIncomeList() {
        return this.financialsData.getDepUnemploymentIncomeList();
    }

    /**
     * @param depUnemploymentIncome
     *            The depUnemploymentIncome to set.
     */
    public void setDepUnemploymentIncomeList(List depUnemploymentIncome) {
        this.financialsData.setDepUnemploymentIncomeList(depUnemploymentIncome);
    }

    /**
     * @return this.financialsData.Returns the depUSCivilServiceIncome.
     */
    public List getDepUSCivilServiceIncomeList() {
        return this.financialsData.getDepUSCivilServiceIncomeList();
    }

    /**
     * @param depUSCivilServiceIncome
     *            The depUSCivilServiceIncome to set.
     */
    public void setDepUSCivilServiceIncomeList(List depUSCivilServiceIncome) {
        this.financialsData.setDepUSCivilServiceIncomeList(depUSCivilServiceIncome);
    }

    /**
     * @return this.financialsData.Returns the depWorkersCompIncome.
     */
    public List getDepWorkersCompIncomeList() {
        return this.financialsData.getDepWorkersCompIncomeList();
    }

    /**
     * @param depWorkersCompIncome
     *            The depWorkersCompIncome to set.
     */
    public void setDepWorkersCompIncomeList(List depWorkersCompIncome) {
        this.financialsData.setDepWorkersCompIncomeList(depWorkersCompIncome);
    }

    /**
     * @return this.financialsData.Returns the depDisplaySSN.
     */
    public List getDepDisplaySSNList() {
        return this.financialsData.getDepDisplaySSNList();
    }

    /**
     * @param depDisplaySSN
     *            The depDisplaySSN to set.
     */
    public void setDepDisplaySSNList(List depDisplaySSN) {
        this.financialsData.setDepDisplaySSNList(depDisplaySSN);
    }

    /**
     * @return this.financialsData.Returns the depFinacialsHashCode.
     */
    public String getDepFinacialsHashCode(int index) {
        return this.financialsData.getDepFinacialsHashCode(index);
    }

    /**
     * @return this.financialsData.Returns the depFinacialsHashCodeList.
     */
    public List getDepFinacialsHashcodeList() {
        return this.financialsData.getDepFinacialsHashcodeList();
    }

    /**
     * @param depFinacialsHashCode
     *            The depFinacialsHashCode to set.
     */
    public void setDepFinacialsHashCode(int index, String depFinacialsHashCode) {
        this.financialsData.setDepFinacialsHashCode(index, depFinacialsHashCode);
    }

    /**
     * @return this.financialsData.Returns the pendingAdjudication.
     */
    public boolean isPendingAdjudication() {
        return this.financialsData.isPendingAdjudication();
    }

    /**
     * @param pendingAdjudication
     *            The pendingAdjudication to set.
     */
    public void setPendingAdjudication(boolean pendingAdjudication) {
        this.financialsData.setPendingAdjudication(pendingAdjudication);
    }

    public void addDependent() {
        this.financialsData.addDependent();
    }

    /**
     * Validate the array type fields that can not be validated declaratively
     * Validates phoneType and Phone Number
     */
    public ActionMessages validateForm(ActionMapping mapping, HttpServletRequest request) {
        // Get the list of existing messages
        MessageResources messageResources = getResources(request);
        ActionMessages messages = getActionMessages(request);

        validateIncomeTestEffectiveDate(messages, messageResources);
      
        /****************CCR12931 - For first 90 days of the calendar year ***********************/
        validatePreviousIncomeYearTestEffectiveDate(messages, messageResources);
        /************************************************************************************/

        List depFinancials = this.financialsData.getDepFinacialsIdList();
        for (int i = 0; i < depFinancials.size(); i++) {
            validateDependentFinancials(i, messages, messageResources);
        }

        return messages;
    }

    public ActionMessages validateDependentFinancials(int depIndex, ActionMessages errors,
            MessageResources messageResources) {
        String index = "[" + (depIndex) + "]";
        String label;
        String depName = " for " + getDepName(depIndex);
        if (StringUtils.isNotEmpty(getDepTotalIncome(depIndex))) {
            label = messageResources.getMessage("label.income.totalEmployment");
            validateDoubleRange(getDepTotalIncome(depIndex), "depTotalIncome" + index, label + depName,
                    errors);

        }
        if (StringUtils.isNotEmpty(getDepIncomeFromRanch(depIndex))) {
            label = messageResources.getMessage("label.income.ranchFarm");
            validateDoubleRange(getDepIncomeFromRanch(depIndex), "depIncomeFromRanch" + index, label
                    + depName, errors);

        }
        if (StringUtils.isNotEmpty(getDepOtherIncome(depIndex))) {
            label = messageResources.getMessage("label.income.other");
            validateDoubleRange(getDepOtherIncome(depIndex), "depOtherIncome" + index, label + depName,
                    errors);

        }
        if (StringUtils.isNotEmpty(getDepSocialSecurityIncome(depIndex))) {
            label = messageResources.getMessage("label.income.socialSecurity");
            validateDoubleRange(getDepSocialSecurityIncome(depIndex), "depSocialSecurityIncome" + index,
                    label + depName, errors);

        }
        if (StringUtils.isNotEmpty(getDepMilitaryRetirementIncome(depIndex))) {
            label = messageResources.getMessage("label.income.milRetirement");
            validateDoubleRange(getDepMilitaryRetirementIncome(depIndex), "depMilitaryRetirementIncome"
                    + index, label + depName, errors);

        }
        if (StringUtils.isNotEmpty(getDepRailroadRetirementIncome(depIndex))) {
            label = messageResources.getMessage("label.income.railRetirement");
            validateDoubleRange(getDepRailroadRetirementIncome(depIndex), "depRailroadRetirementIncome"
                    + index, label + depName, errors);

        }
        if (StringUtils.isNotEmpty(getDepUSCivilServiceIncome(depIndex))) {
            label = messageResources.getMessage("label.income.usCivilService");
            validateDoubleRange(getDepUSCivilServiceIncome(depIndex), "depUSCivilServiceIncome" + index,
                    label + depName, errors);

        }
        if (StringUtils.isNotEmpty(getDepUnemploymentIncome(depIndex))) {
            label = messageResources.getMessage("label.income.unemployment");
            validateDoubleRange(getDepUnemploymentIncome(depIndex), "depUnemploymentIncome" + index, label
                    + depName, errors);

        }
        if (StringUtils.isNotEmpty(getDepWorkersCompIncome(depIndex))) {
            label = messageResources.getMessage("label.income.workersComp");
            validateDoubleRange(getDepWorkersCompIncome(depIndex), "depWorkersCompIncome" + index, label
                    + depName, errors);

        }
        if (StringUtils.isNotEmpty(getDepOtherRetirementIncome(depIndex))) {
            label = messageResources.getMessage("label.income.otherRetirement");
            validateDoubleRange(getDepOtherRetirementIncome(depIndex), "depOtherRetirementIncome" + index,
                    label + depName, errors);

        }
        if (StringUtils.isNotEmpty(getDepInterestDividentAnuityIncome(depIndex))) {
            label = messageResources.getMessage("label.income.interst");
            validateDoubleRange(getDepInterestDividentAnuityIncome(depIndex),
                    "depInterestDividentAnuityIncome" + index, label + depName, errors);

        }
        // asset
        if (StringUtils.isNotEmpty(getDepCashAsset(depIndex))) {
            label = messageResources.getMessage("label.asset.cash");
            validateDoubleRange(getDepCashAsset(depIndex), "depCashAsset" + index, label + depName, errors);

        }
        if (StringUtils.isNotEmpty(getDepRealAsset(depIndex))) {
            label = messageResources.getMessage("label.asset.real");
            validateDoubleRange(getDepRealAsset(depIndex), "depRealAsset" + index, label + depName, errors);

        }
        if (StringUtils.isNotEmpty(getDepOtherAsset(depIndex))) {
            label = messageResources.getMessage("label.asset.other");
            validateDoubleRange(getDepOtherAsset(depIndex), "depOtherAsset" + index, label + depName, errors);

        }
        if (StringUtils.isNotEmpty(getDepStocksAsset(depIndex))) {
            label = messageResources.getMessage("label.asset.stocks");
            validateDoubleRange(getDepStocksAsset(depIndex), "depStocksAsset" + index, label + depName,
                    errors);

        }

        if (StringUtils.isNotEmpty(getDepEduExpenses(depIndex))) {
            label = messageResources.getMessage("label.expense.edu");
            validateDoubleRange(getDepEduExpenses(depIndex), "depEduExpenses" + index, label + depName,
                    errors);

        }
        if (StringUtils.isNotEmpty(getDepAmtContributed(depIndex))) {
            label = messageResources.getMessage("label.dep.amtContributed");
            validateDoubleRange(getDepAmtContributed(depIndex), "depAmtContributed" + index, label + depName,
                    errors);

        }
        if (StringUtils.isNotEmpty(getDepEffectiveDate(depIndex))) {
            label = messageResources.getMessage("label.dep.effDate");
            validateImpreciseDate(getDepEffectiveDate(depIndex), "depEffectiveDate" + index, label + depName,
                    errors);

        }
        if (StringUtils.isNotEmpty(getDepInactiveDate(depIndex))) {
            label = messageResources.getMessage("label.dep.inactiveDate");
            validatePreciseDate(getDepInactiveDate(depIndex), "depInactiveDate" + index, label + depName,
                    errors);

        }

        return errors;
    }

    private void validateIncomeTestEffectiveDate(ActionMessages messages, MessageResources messageResources) {

        if (StringUtils.isNotEmpty(this.financialsData.getTestEffDate())
                && StringUtils.isNotEmpty(this.financialsData.getIncomeYear())) {
            try {
                Date effectiveDate = CommonDateUtils.getDate(this.financialsData.getTestEffDate());
                Date incomeYearEndDate = CommonDateUtils.getDate("12/31/" + this.financialsData.getIncomeYear());
                if (!incomeYearEndDate.before(effectiveDate)) {
                    String label = messageResources.getMessage("label.financials.testeffdate");
                    messages.add("testEffDate", new ActionMessage("errors.effectiveDateWithinIncomeYear",
                            label));
                }
            } catch (Exception ex) {
                // Ignore
            }
        }
    }

    /*************CCR12931- Method to validate the test effective date of the previous income year entry for the first 90 days of the current calenday year************************/
    private void validatePreviousIncomeYearTestEffectiveDate(ActionMessages messages, MessageResources messageResources) {
         
        Calendar calendar = Calendar.getInstance();
        /*** Commented out as it is not used
        int dayOfYear = calendar.get(Calendar.DAY_OF_YEAR);  
        ***/
        int year = calendar.get(Calendar.YEAR)-2;
        int incomeYear = Integer.parseInt(this.financialsData.getIncomeYear());
        
        if (StringUtils.isNotEmpty(this.financialsData.getTestEffDate())
                && StringUtils.isNotEmpty(this.financialsData.getIncomeYear()) && incomeYear == year   ) {
            try {
                Date effectiveDate = CommonDateUtils.getDate(this.financialsData.getTestEffDate());
                /*** Commented out as it is not used
                Date previousIncomeYearEndDate = CommonDateUtils.getDate("12/31/" + this.financialsData.getIncomeYear());
                Date incomeYearEndDate = CommonDateUtils.getDate("12/31/" + String.valueOf(Integer.parseInt(this.financialsData.getIncomeYear())+1));
                Date nextIncomeYearEndDate = CommonDateUtils.getDate("12/31/" + String.valueOf(Integer.parseInt(this.financialsData.getIncomeYear())+2));
                ***/
                
               /************Validating previous income year entry of test effective date not to be in current calendar year*******************
               * Commented out and condition is changed as per error message. See below newly added condition with test scenarios.
               if (( !incomeYearEndDate.after(effectiveDate) && !nextIncomeYearEndDate.before(effectiveDate) ) ) {
               ***/
               /************ Validating effective date year with income year to ensure that
                *  the test effective date year cannot be more than Income Year of the test + 1.
                *  
                *  Otherwise error is returned:
                *  "Test Effective Date year cannot be more than Income Year of the test + 1".
                *  
                *  For example:
                *  1. If 12/31/2015 as test effective date and 2014 as income year of test then
                *     2015 <= (2014 + 1) is allowed.
                *  2. If 1/5/2016 as test effective date and 2014 as income year of test then
                *     2016 > (2014 + 1) is NOT allowed.
                */
               
                calendar.setTime(effectiveDate);
                int effectiveDateYear = calendar.get(Calendar.YEAR);
                
                if (effectiveDateYear > (incomeYear + 1)) {                
                    String label = messageResources.getMessage("label.financials.testeffdate");
                    messages.add("testEffDate", new ActionMessage("errors.effectiveDateWithinIncomeYearPlusOne", label));
                }
            } catch (Exception ex) {
                // Ignore
            }
        }
    }
    /***************************************************************************************************************************************************************/
       
    public static boolean validateImpreciseDate(String dateStr, String fieldName, String fieldLabel,
            ActionMessages errors) {
        // If no value was specified, assume that the field is valid
        if (StringUtils.isEmpty(dateStr)) {
            return true;
        }

        boolean fieldValid = true;
        try {
            // Validate the imprecise date
            CommonDateUtils.getImpreciseDate(dateStr);
        } catch (Exception e) {
            // Field parsing exception so it isn't valid
            fieldValid = false;
        }

        // Add the error message if invalid
        if (!fieldValid) {
            errors.add(fieldName, new ActionMessage("errors.imprecisedate", fieldLabel));
        }

        // Return whether the field is valid or not
        return fieldValid;
    }

    public static boolean validatePreciseDate(String dateStr, String fieldName, String fieldLabel,
            ActionMessages errors) {
        // If no value was specified, assume that the field is valid
        if (StringUtils.isEmpty(dateStr)) {
            return true;
        }

        boolean fieldValid = true;
        try {
            boolean timeSupported = false;

            // Validate the precise date
            CommonDateUtils.getDate(dateStr, timeSupported);
        } catch (Exception e) {
            // Field parsing exception so it isn't valid
            fieldValid = false;
        }

        // Add the error message if invalid
        if (!fieldValid) {
            errors.add(fieldName, new ActionMessage("errors.date", fieldLabel));
        }

        // Return whether the field is valid or not
        return fieldValid;
    }

    public static boolean validateDoubleRange(String fieldValue, String fieldName, String fieldLabel,
            ActionMessages errors) {
        boolean isValid = true;
        Double minValue = new Double(0);
        Double maxValue = new Double(9999999.99);
        try {
            Double d = new Double(fieldValue);
            if (d.doubleValue() < 0 || d.doubleValue() > 9999999.99) {
                errors.add(fieldName, new ActionMessage("errors.range", fieldLabel, minValue,
                        maxValue));
                isValid = false;
            }
        } catch (NumberFormatException e) {
            errors.add(fieldName, new ActionMessage("errors.double", fieldLabel));
            isValid = false;
        }
        return isValid;
    }
    
    private void initialize() {
        financialsData = new FinancialDetailsData();

        //inactive spouse
        spouseFinacialsId = new ArrayList();
        spouseSSN = new ArrayList();
        spouseDisplaySSN = new ArrayList();
        spouseRelationshipCode = new ArrayList();
        spouseRelationship = new ArrayList();
        spouseGenderCode = new ArrayList();
        spouseGender = new ArrayList();
        spouseName = new ArrayList();
        spouseValid = new ArrayList();
        spouseInactiveDate = new ArrayList();
        spouseLivedWithPatient = new ArrayList();
        spouseContributedToSupport = new ArrayList();
        spouseMarriageDate = new ArrayList();
        spouseTotalIncome = new ArrayList();
        spouseIncomeFromRanch = new ArrayList();
        spouseOtherIncome = new ArrayList();
        spouseEduExpenses = new ArrayList();
        spouseCashAsset = new ArrayList();
        spouseRealAsset = new ArrayList();
        spouseOtherAsset = new ArrayList();
        spouseStocksAsset = new ArrayList();
        spouseUSCivilServiceIncome = new ArrayList();
        spouseInterestDividentAnuityIncome = new ArrayList();    
        spouseUnemploymentIncome = new ArrayList(); 
        spouseSocialSecurityIncome = new ArrayList();
        spouseMilitaryRetirementIncome = new ArrayList();
        spouseRailroadRetirementIncome = new ArrayList();
        spouseOtherRetirementIncome = new ArrayList();
        spouseWorkersCompIncome = new ArrayList();
        spouseFinacialsHashCode = new ArrayList();
        spouseDebt = new ArrayList();
        spouseActive = new ArrayList();
        contributedToSpousalSupport = new ArrayList();
    }
    public void addSpouse()
    {
        spouseFinacialsId.add("");
        spouseSSN.add("");
        spouseDisplaySSN.add("");
        spouseRelationshipCode.add("");
        spouseRelationship.add("");
        spouseGenderCode.add("");
        spouseGender.add("");
        spouseName.add("");
        spouseValid.add("");
        spouseInactiveDate.add("");
        spouseLivedWithPatient.add("");
        spouseContributedToSupport.add("");
        spouseMarriageDate.add("");
        spouseTotalIncome.add("");
        spouseIncomeFromRanch.add("");
        spouseOtherIncome.add("");
        spouseEduExpenses.add("");
        spouseCashAsset.add("");
        spouseRealAsset.add("");
        spouseOtherAsset.add("");
        spouseStocksAsset.add("");
        spouseUSCivilServiceIncome.add("");
        spouseInterestDividentAnuityIncome.add("");    
        spouseUnemploymentIncome.add(""); 
        spouseSocialSecurityIncome.add("");
        spouseMilitaryRetirementIncome.add("");
        spouseRailroadRetirementIncome.add("");
        spouseOtherRetirementIncome.add("");
        spouseWorkersCompIncome.add("");
        spouseFinacialsHashCode.add("");        
        spouseDebt.add("");
        spouseActive.add("");
        contributedToSpousalSupport.add("");
    }
    
    public String getSpouseActive(int index) {
        return (String)this.spouseActive.get(index);
    }
    
    public String getSpouseMarriageDate(int index) {
        return (String)this.spouseMarriageDate.get(index);
    }

    public String getSpouseCashAsset(int index) {
        return (String)this.spouseCashAsset.get(index);
    }

    public String getSpouseContributedToSupport(int index) {
        return (String)this.spouseContributedToSupport.get(index);
    }
    
    public String getSpouseDebt(int index) {
        return (String)this.spouseDebt.get(index);
    }
    
    public String getSpouseDisplaySSN(int index) {
        return (String)this.spouseDisplaySSN.get(index);
    }

    public String getSpouseEduExpenses(int index) {
        return (String)this.spouseEduExpenses.get(index);
    }

    public String getSpouseFinacialsHashCode(int index) {
        return (String)this.spouseFinacialsHashCode.get(index);
    }

    public String getSpouseFinacialsId(int index) {
        return (String)this.spouseFinacialsId.get(index);
    }

    public String getSpouseGender(int index) {
        return (String)this.spouseGender.get(index);
    }

    public String getSpouseGenderCode(int index) {
        return (String)this.spouseGenderCode.get(index);
    }

    public String getSpouseInactiveDate(int index) {
        return (String)this.spouseInactiveDate.get(index);
    }

    public String getSpouseIncomeFromRanch(int index) {
        return (String)this.spouseIncomeFromRanch.get(index);
    }

    public String getSpouseInterestDividentAnuityIncome(int index) {
        return (String)this.spouseInterestDividentAnuityIncome.get(index);
    }

    public String getSpouseLivedWithPatient(int index) {
        //Stage 1b fix - if block
        //add an empty element to address display error causes 
        //when no selection for this field is made on dependentSpouseForm

        if(this.spouseLivedWithPatient != null && this.spouseLivedWithPatient.isEmpty()){
            this.setSpouseLivedWithPatient(index, null);
        }
        
        return (String)this.spouseLivedWithPatient.get(index);
    }

    public String getSpouseMilitaryRetirementIncome(int index) {
        return (String)this.spouseMilitaryRetirementIncome.get(index);
    }

    public String getSpouseName(int index) {
        return (String)this.spouseName.get(index);
    }

    public String getSpouseOtherAsset(int index) {
        return (String)this.spouseOtherAsset.get(index);
    }

    public String getSpouseOtherIncome(int index) {
        return (String)this.spouseOtherIncome.get(index);
    }

    public String getSpouseOtherRetirementIncome(int index) {
        return (String)this.spouseOtherRetirementIncome.get(index);
    }

    public String getSpouseRailroadRetirementIncome(int index) {
        return (String)this.spouseRailroadRetirementIncome.get(index);
    }

    public String getSpouseRealAsset(int index) {
        return (String)this.spouseRealAsset.get(index);
    }

    public String getSpouseRelationship(int index) {
        return (String)this.spouseRelationship.get(index);
    }

    public String getSpouseRelationshipCode(int index) {
        return (String)this.spouseRelationshipCode.get(index);
    }

    public String getSpouseSocialSecurityIncome(int index) {
        return (String)this.spouseSocialSecurityIncome.get(index);
    }

    public String getSpouseSSN(int index) {
        return (String)this.spouseSSN.get(index);
    }

    public String getSpouseStocksAsset(int index) {
        return (String)this.spouseStocksAsset.get(index);
    }

    public String getSpouseTotalIncome(int index) {
        return (String)this.spouseTotalIncome.get(index);
    }

    public String getSpouseUnemploymentIncome(int index) {
        return (String)this.spouseUnemploymentIncome.get(index);
    }

    public String getSpouseUSCivilServiceIncome(int index) {
        return (String)this.spouseUSCivilServiceIncome.get(index);
    }

    public String getSpouseValid(int index) {
        return (String)this.spouseValid.get(index);
    }

    public String getSpouseWorkersCompIncome(int index) {
        return (String)this.spouseWorkersCompIncome.get(index);
    }
    
    public void setSpouseActive(int index, String spouseActive) {
        setElement(this.spouseActive, index, spouseActive);
    }
    
    public void setSpouseMarriageDate(int index, String spouseMarriageDate) {
        setElement(this.spouseMarriageDate, index, spouseMarriageDate);
    }

    public void setSpouseCashAsset(int index, String spouseCashAsset) {
        setElement(this.spouseCashAsset, index, spouseCashAsset);
    }

    public void setSpouseContributedToSupport(int index, String spouseContributedToSupport) {
        setElement(this.spouseContributedToSupport, index, spouseContributedToSupport);
    }
    
    public void setSpouseDebt(int index, String spouseDebt) {
        setElement(this.spouseDebt, index, spouseDebt);
    }
    
    public void setSpouseDisplaySSN(int index, String spouseDisplaySSN) {
        setElement(this.spouseDisplaySSN, index, spouseDisplaySSN);
    }

    public void setSpouseEduExpenses(int index, String spouseEduExpenses) {
        setElement(this.spouseEduExpenses, index, spouseEduExpenses);
    }

    public void setSpouseFinacialsHashCode(int index, String spouseFinacialsHashCode) {
        setElement(this.spouseFinacialsHashCode, index, spouseFinacialsHashCode);
    }

    public void setSpouseFinacialsId(int index, String spouseFinacialsId) {
        setElement(this.spouseFinacialsId, index, spouseFinacialsId);
    }

    public void setSpouseGender(int index, String spouseGender) {
        setElement(this.spouseGender, index, spouseGender);
    }

    public void setSpouseGenderCode(int index, String spouseGenderCode) {
        setElement(this.spouseGenderCode, index, spouseGenderCode);
    }

    public void setSpouseInactiveDate(int index, String spouseInactiveDate) {
        setElement(this.spouseInactiveDate, index, spouseInactiveDate);
    }

    public void setSpouseIncomeFromRanch(int index, String spouseIncomeFromRanch) {
        setElement(this.spouseIncomeFromRanch, index, spouseIncomeFromRanch);
    }

    public void setSpouseInterestDividentAnuityIncome(
            int index, String spouseInterestDividentAnuityIncome) {
        setElement(this.spouseInterestDividentAnuityIncome, index, spouseInterestDividentAnuityIncome);
    }

    public void setSpouseLivedWithPatient(int index, String spouseLivedWithPatient) {
        setElement(this.spouseLivedWithPatient, index, spouseLivedWithPatient);
    }

    public void setSpouseMilitaryRetirementIncome(
            int index, String spouseMilitaryRetirementIncome) {
        setElement(this.spouseMilitaryRetirementIncome, index, spouseMilitaryRetirementIncome);
    }

    public void setSpouseName(int index, String spouseName) {
        setElement(this.spouseName, index, spouseName);
    }

    public void setSpouseOtherAsset(int index, String spouseOtherAsset) {
        setElement(this.spouseOtherAsset, index, spouseOtherAsset);
    }

    public void setSpouseOtherIncome(int index, String spouseOtherIncome) {
        setElement(this.spouseOtherIncome, index, spouseOtherIncome);
    }

    public void setSpouseOtherRetirementIncome(int index, String spouseOtherRetirementIncome) {
        setElement(this.spouseOtherRetirementIncome, index, spouseOtherRetirementIncome);
    }

    public void setSpouseRailroadRetirementIncome(
            int index, String spouseRailroadRetirementIncome) {
        setElement(this.spouseRailroadRetirementIncome, index, spouseRailroadRetirementIncome);
    }

    public void setSpouseRealAsset(int index, String spouseRealAsset) {
        setElement(this.spouseRealAsset, index, spouseRealAsset);
    }

    public void setSpouseRelationship(int index, String spouseRelationship) {
        setElement(this.spouseRelationship, index, spouseRelationship);
    }

    public void setSpouseRelationshipCode(int index, String spouseRelationshipCode) {
        setElement(this.spouseRelationshipCode, index, spouseRelationshipCode);
    }

    public void setSpouseSocialSecurityIncome(int index, String spouseSocialSecurityIncome) {
        setElement(this.spouseSocialSecurityIncome, index, spouseSocialSecurityIncome);
    }

    public void setSpouseSSN(int index, String spouseSSN) {
        setElement(this.spouseSSN, index, spouseSSN);
    }

    public void setSpouseStocksAsset(int index, String spouseStocksAsset) {
        setElement(this.spouseStocksAsset, index, spouseStocksAsset);
    }

    public void setSpouseTotalIncome(int index, String spouseTotalIncome) {
        setElement(this.spouseTotalIncome, index, spouseTotalIncome);
    }

    public void setSpouseUnemploymentIncome(int index, String spouseUnemploymentIncome) {
        setElement(this.spouseUnemploymentIncome, index, spouseUnemploymentIncome);
    }

    public void setSpouseUSCivilServiceIncome(int index, String spouseUSCivilServiceIncome) {
        setElement(this.spouseUSCivilServiceIncome, index, spouseUSCivilServiceIncome);
    }

    public void setSpouseValid(int index, String spouseValid) {
        setElement(this.spouseValid, index, spouseValid);
    }

    public void setSpouseWorkersCompIncome(int index, String spouseWorkersCompIncome) {
        setElement(this.spouseWorkersCompIncome, index, spouseWorkersCompIncome);
    }
    
    //Inactive spouse list access methods    
    public List getSpouseActiveList() {
        return this.spouseActive;
    }
    
    public List getSpouseMarriageDateList() {
        return this.spouseMarriageDate;
    }

    public List getSpouseCashAssetList() {
        return this.spouseCashAsset;
    }

    public List getSpouseContributedToSupportList() {
        return this.spouseContributedToSupport;
    }

    public List getSpouseDebtList() {
        return this.spouseDebt;
    }
    
    public List getSpouseDisplaySSNList() {
        return this.spouseDisplaySSN;
    }

    public List getSpouseEduExpensesList() {
        return this.spouseEduExpenses;
    }

    public List getSpouseFinacialsHashCodeList() {
        return this.spouseFinacialsHashCode;
    }

    public List getSpouseFinacialsIdList() {
        return this.spouseFinacialsId;
    }

    public List getSpouseGenderList() {
        return this.spouseGender;
    }

    public List getSpouseGenderCodeList() {
        return this.spouseGenderCode;
    }

    public List getSpouseInactiveDateList() {
        return this.spouseInactiveDate;
    }

    public List getSpouseIncomeFromRanchList() {
        return this.spouseIncomeFromRanch;
    }

    public List getSpouseInterestDividentAnuityIncomeList() {
        return this.spouseInterestDividentAnuityIncome;
    }

    public List getSpouseLivedWithPatientList() {
        return this.spouseLivedWithPatient;
    }

    public List getSpouseMilitaryRetirementIncomeList() {
        return this.spouseMilitaryRetirementIncome;
    }

    public List getSpouseNameList() {
        return this.spouseName;
    }

    public List getSpouseOtherAssetList() {
        return this.spouseOtherAsset;
    }

    public List getSpouseOtherIncomeList() {
        return this.spouseOtherIncome;
    }

    public List getSpouseOtherRetirementIncomeList() {
        return this.spouseOtherRetirementIncome;
    }

    public List getSpouseRailroadRetirementIncomeList() {
        return this.spouseRailroadRetirementIncome;
    }

    public List getSpouseRealAssetList() {
        return this.spouseRealAsset;
    }

    public List getSpouseRelationshipList() {
        return this.spouseRelationship;
    }

    public List getSpouseRelationshipCodeList() {
        return this.spouseRelationshipCode;
    }

    public List getSpouseSocialSecurityIncomeList() {
        return this.spouseSocialSecurityIncome;
    }

    public List getSpouseSSNList() {
        return this.spouseSSN;
    }

    public List getSpouseStocksAssetList() {
        return this.spouseStocksAsset;
    }

    public List getSpouseTotalIncomeList() {
        return this.spouseTotalIncome;
    }

    public List getSpouseUnemploymentIncomeList() {
        return this.spouseUnemploymentIncome;
    }

    public List getSpouseUSCivilServiceIncomeList() {
        return this.spouseUSCivilServiceIncome;
    }

    public List getSpouseValidList() {
        return this.spouseValid;
    }

    public List getSpouseWorkersCompIncomeList() {
        return this.spouseWorkersCompIncome;
    }
    
    public void setSpouseActiveList(List spouseActive) {
        this.spouseActive = spouseActive;
    }
    
    public void setSpouseMarriageDateList(List spouseMarriageDate) {
        this.spouseMarriageDate = spouseMarriageDate;
    }

    public void setSpouseCashAssetList(List spouseCashAsset) {
        this.spouseCashAsset = spouseCashAsset;
    }

    public void setSpouseContributedToSupportList(List spouseContributedToSupport) {
        this.spouseContributedToSupport = spouseContributedToSupport;
    }

    public void setSpouseDebtList(List spouseDebt) {
        this.spouseDebt = spouseDebt;
    }
    
    public void setSpouseDisplaySSNList(List spouseDisplaySSN) {
        this.spouseDisplaySSN = spouseDisplaySSN;
    }

    public void setSpouseEduExpensesList(List spouseEduExpenses) {
        this.spouseEduExpenses = spouseEduExpenses;
    }
                   
    public void setSpouseFinacialsHashCodeList(List spouseFinacialsHashCode) {
        this.spouseFinacialsHashCode = spouseFinacialsHashCode;
    }

    public void setSpouseFinacialsIdList(List spouseFinacialsId) {
        this.spouseFinacialsId = spouseFinacialsId;
    }

    public void setSpouseGenderList(List spouseGender) {
        this.spouseGender = spouseGender;
    }

    public void setSpouseGenderCodeList(List spouseGenderCode) {
        this.spouseGenderCode = spouseGenderCode;
    }

    public void setSpouseInactiveDateList(List spouseInactiveDate) {
        this.spouseInactiveDate = spouseInactiveDate;
    }

    public void setSpouseIncomeFromRanchList(List spouseIncomeFromRanch) {
        this.spouseIncomeFromRanch = spouseIncomeFromRanch;
    }

    public void setSpouseInterestDividentAnuityIncomeList(
            List spouseInterestDividentAnuityIncome) {
        this.spouseInterestDividentAnuityIncome = spouseInterestDividentAnuityIncome;
    }

    public void setSpouseLivedWithPatientList(List spouseLivedWithPatient) {
        this.spouseLivedWithPatient = spouseLivedWithPatient;
    }

    public void setSpouseMilitaryRetirementIncomeList(List spouseMilitaryRetirementIncome) {
        this.spouseMilitaryRetirementIncome = spouseMilitaryRetirementIncome;
    }

    public void setSpouseNameList(List spouseName) {
        this.spouseName = spouseName;
    }

    public void setSpouseOtherAssetList(List spouseOtherAsset) {
        this.spouseOtherAsset = spouseOtherAsset;
    }

    public void setSpouseOtherIncomeList(List spouseOtherIncome) {
        this.spouseOtherIncome = spouseOtherIncome;
    }

    public void setSpouseOtherRetirementIncomeList(List spouseOtherRetirementIncome) {
        this.spouseOtherRetirementIncome = spouseOtherRetirementIncome;
    }

    public void setSpouseRailroadRetirementIncomeList(
            List spouseRailroadRetirementIncome) {
        this.spouseRailroadRetirementIncome = spouseRailroadRetirementIncome;
    }

    public void setSpouseRealAssetList(List spouseRealAsset) {
        this.spouseRealAsset = spouseRealAsset;
    }

    public void setSpouseRelationshipList(List spouseRelationship) {
        this.spouseRelationship = spouseRelationship;
    }

    public void setSpouseRelationshipCodeList(List spouseRelationshipCode) {
        this.spouseRelationshipCode = spouseRelationshipCode;
    }

    public void setSpouseSocialSecurityIncomeList(List spouseSocialSecurityIncome) {
        this.spouseSocialSecurityIncome = spouseSocialSecurityIncome;
    }

    public void setSpouseSSNList(List spouseSSN) {
        this.spouseSSN = spouseSSN;
    }

    public void setSpouseStocksAssetList(List spouseStocksAsset) {
        this.spouseStocksAsset = spouseStocksAsset;
    }

    public void setSpouseTotalIncomeList(List spouseTotalIncome) {
        this.spouseTotalIncome = spouseTotalIncome;
    }

    public void setSpouseUnemploymentIncomeList(List spouseUnemploymentIncome) {
        this.spouseUnemploymentIncome = spouseUnemploymentIncome;
    }

    public void setSpouseUSCivilServiceIncomeList(List spouseUSCivilServiceIncome) {
        this.spouseUSCivilServiceIncome = spouseUSCivilServiceIncome;
    }

    public void setSpouseValidList(List spouseValid) {
        this.spouseValid = spouseValid;
    }

    public void setSpouseWorkersCompIncomeList(List spouseWorkersCompIncome) {
        this.spouseWorkersCompIncome = spouseWorkersCompIncome;
    }

	public Boolean getBtFinancialInd() {
		return btFinancialInd;
	}

	public void setBtFinancialInd(Boolean btFinancialInd) {
		this.btFinancialInd = btFinancialInd;
	}

   
    public List getContributedToSpousalSupport() {
        return contributedToSpousalSupport;
    }

    
    public void setContributedToSpousalSupport(List contributedToSpousalSupport) {
        this.contributedToSpousalSupport = contributedToSpousalSupport;
    }        
    
    public String getContributedToSpousalSupport(int index) {
        return (String)this.contributedToSpousalSupport.get(index);
    }
    
    public void setContributedToSpousalSupport(int index, String contributedToSpousalSupport) {
        setElement(this.contributedToSpousalSupport, index, contributedToSpousalSupport);
    }
}