package gov.va.med.esr.common.ui.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

/**
 * FinancialDetailsData
 * Created Jul 28, 2006 5:43:50 PM
 * @author DNS   MANSOG
 */
public class FinancialDetailsData implements Serializable {

	private static final long serialVersionUID = 5470954551604001786L;
	
	private final static String NULL_VALUE = "nd";
		
    //used to indicate if in add mode
    private boolean newIncomeTestInd = false;
    
    //used to indicate if there is a income test for the person
    private boolean incomeTestAvaliableInd = false;
    
    //used to indicate if post2005 or pre2005 format for the financial amounts
    private boolean post2005formatInd = true;
    
    private boolean askAdjudicationQuestion = false;
    private String  sourceOfTest = null;
    
    //Status based on MT Status 
    private boolean pendingAdjudication = false;
    
    private String sendForAdjudication;
    private String incomeYear;
    private String testEffDate;
    private String discloseFinIncome;
    private String agreeToPayDeductible;
    private String marriedLastCalendarYear;
    private String name;
    private String displayName;
    
    private String totalEmploymentIncome;
    private String netIncomeFromFarmRanchOrBusiness;
    private String otherIncome;
    private String educationExpense;
    private String nonReimbMedicalExpense;
    private String adjustedMedicalExpense;   
    private String funeralBurialExpense;
    private String cashAndBankAccountAsset;
    private String realPropertyAsset;
    private String otherPropertyAsset;
    private String stocksAsset;
    private String debt;
    
    //pre2005 incomes
    private String USCivilServiceIncome;
    private String interestDividentAnuityIncome;    
    private String unemploymentIncome; 
    private String socialSecurityIncome;
    private String militaryRetirementIncome;
    private String railroadRetirementIncome;
    private String otherRetirementIncome;
    private String workersCompIncome;
    
    private SpouseFinancialInfoBean spouseInfo = new SpouseFinancialInfoBean();
    private List dependentInfoList = new ArrayList();
    
    private List depFinacialsId;
    private List depSSN;
    private List depDisplaySSN;
    private List depRelationshipCode;
    private List depRelationship;
    private List depGenderCode;
    private List depGender;
    private List depName;
    private List depEffectiveDate;
    private List depValid;
    private List depInactiveDate;
    private List depLivedWithPatient;
    private List depContributedToSupport;
    private List depAmtContributed;
    private List depHasIncome;
    private List depIncomeAvailableToPatient;
    private List depAttendedSchool;
    private List depIncapableOfSelfSupport;
    private List depTotalIncome;
    private List depIncomeFromRanch;
    private List depOtherIncome;
    private List depEduExpenses;
    private List depCashAsset;
    private List depRealAsset;
    private List depOtherAsset;
    private List depStocksAsset;
    private List depUSCivilServiceIncome;
    private List depInterestDividentAnuityIncome;    
    private List depUnemploymentIncome; 
    private List depSocialSecurityIncome;
    private List depMilitaryRetirementIncome;
    private List depRailroadRetirementIncome;
    private List depOtherRetirementIncome;
    private List depWorkersCompIncome;
    private List depFinacialsHashCode;


    /**
     * Default constructor.
     */
    public FinancialDetailsData()
    {
        super();
        initialize();
    }

    public void initialize()
    {
        depFinacialsId = new ArrayList();
        depName = new ArrayList();
        depSSN = new ArrayList();
        depRelationshipCode = new ArrayList();
        depRelationship = new ArrayList();
        depGenderCode = new ArrayList();
        depGender = new ArrayList();
        depEffectiveDate = new ArrayList();
        depValid = new ArrayList();
        depInactiveDate = new ArrayList();
        depLivedWithPatient = new ArrayList();
        depContributedToSupport = new ArrayList();
        depAmtContributed = new ArrayList();
        depHasIncome = new ArrayList();
        depIncomeAvailableToPatient = new ArrayList();
        depAttendedSchool = new ArrayList();
        depIncapableOfSelfSupport = new ArrayList();
        depTotalIncome = new ArrayList();
        depIncomeFromRanch = new ArrayList();
        depOtherIncome = new ArrayList();
        depEduExpenses = new ArrayList();
        depCashAsset = new ArrayList();
        depRealAsset = new ArrayList();
        depOtherAsset = new ArrayList();
        depStocksAsset = new ArrayList();
        depUSCivilServiceIncome = new ArrayList();
        depInterestDividentAnuityIncome = new ArrayList();    
        depUnemploymentIncome = new ArrayList(); 
        depSocialSecurityIncome = new ArrayList();
        depMilitaryRetirementIncome = new ArrayList();
        depRailroadRetirementIncome = new ArrayList();
        depOtherRetirementIncome = new ArrayList();
        depWorkersCompIncome = new ArrayList();
        depDisplaySSN = new ArrayList();
        depFinacialsHashCode = new ArrayList();
        

    }
    
    /**
     * @return Returns the post2005formatInd.
     */
    public boolean getPost2005formatInd() {
        return post2005formatInd;
    }
    /**
     * @param post2005formatInd The post2005formatInd to set.
     */
    public void setPost2005formatInd(boolean post2005formatInd) {
    	
        this.post2005formatInd = post2005formatInd;
    }
    /**
     * @return Returns the agreeToPayDeductible.
     */
    public String getAgreeToPayDeductible() {
        return agreeToPayDeductible;
    }
    /**
     * @param agreeToPayDeductible The agreeToPayDeductible to set.
     */
    public void setAgreeToPayDeductible(String agreeToPayDeductible) {
        this.agreeToPayDeductible = agreeToPayDeductible;
    }
    /**
     * @return Returns the discloseFinIncome.
     */
    public String getDiscloseFinIncome() {
        return discloseFinIncome;
    }
    /**
     * @param discloseFinIncome The discloseFinIncome to set.
     */
    public void setDiscloseFinIncome(String discloseFinIncome) {
    	discloseFinIncome = StringUtils.stripToNull(discloseFinIncome);
        this.discloseFinIncome = discloseFinIncome;
    }
    
    /**
     * @return Returns the askAdjudicationQuestion.
     */
    public boolean getAskAdjudicationQuestion() {
        return askAdjudicationQuestion;
    }
    
    /**
     * @param askAdjudicationQuestion The askAdjudicationQuestion to set.
     */
    public void setAskAdjudicationQuestion(boolean askAdjudicationQuestion) {
        this.askAdjudicationQuestion = askAdjudicationQuestion;
    }
    
    /**
     * @return Returns the sendForAdjudication.
     */
    public String getSendForAdjudication() {
        return sendForAdjudication;
    }
    
    /**
     * @param sendForAdjudication The sendForAdjudication to set.
     */
    public void setSendForAdjudication(String sendForAdjudication) {
        this.sendForAdjudication = sendForAdjudication;
    }

    /**
     * @return Returns the incomeYear.
     */
    public String getIncomeYear() {
        return incomeYear;
    }
    /**
     * @param incomeYear The incomeYear to set.
     */
    public void setIncomeYear(String incomeYear) {
    	incomeYear = StringUtils.stripToNull(incomeYear);
        this.incomeYear = incomeYear;
    }
    /**
     * @return Returns the marriedLastCalendarYear.
     */
    public String getMarriedLastCalendarYear() {
        return marriedLastCalendarYear;
    }
    /**
     * @param marriedLastCalendarYear The marriedLastCalendarYear to set.
     */
    public void setMarriedLastCalendarYear(String marriedLastCalendarYear) {
        this.marriedLastCalendarYear = marriedLastCalendarYear;
    }
    /**
     * @return Returns the testEffDate.
     */
    public String getTestEffDate() {
        return testEffDate;
    }
    /**
     * @param testEffDate The testEffDate to set.
     */
    public void setTestEffDate(String testEffDate) {
    	testEffDate = StringUtils.stripToNull(testEffDate);
        this.testEffDate = testEffDate;
    }
    /**
     * @return Returns the isNewIncomeTest.
     */
    public boolean getNewIncomeTestInd() {
        return newIncomeTestInd;
    }
    /**
     * @param isNewIncomeTest The isNewIncomeTest to set.
     */
    public void setNewIncomeTestInd(boolean isNewIncomeTest) {
        this.newIncomeTestInd = isNewIncomeTest;
    }
    /**
     * @return Returns the incomeTestAvaliableInd.
     */
    public boolean getIncomeTestAvaliableInd() {
        return incomeTestAvaliableInd;
    }
    /**
     * @param incomeTestAvaliableInd The incomeTestAvaliableInd to set.
     */
    public void setIncomeTestAvaliableInd(boolean incomeTestAvaliableInd) {
        this.incomeTestAvaliableInd = incomeTestAvaliableInd;
    }
    /**
     * @return Returns the sourceOfTest.
     */
    public String getSourceOfTest() {
        return sourceOfTest;
    }
    /**
     * @param sourceOfTest The sourceOfTest to set.
     */
    public void setSourceOfTest(String sourceOfTest) {
        this.sourceOfTest = sourceOfTest;
    }
    /**
     * @return Returns the cashAndBankAccountAsset.
     */
    public String getCashAndBankAccountAsset() {
        return cashAndBankAccountAsset;
    }
    /**
     * @param cashAndBankAccountAsset The cashAndBankAccountAsset to set.
     */
    public void setCashAndBankAccountAsset(String cashAndBankAccountAsset) {
    	cashAndBankAccountAsset = StringUtils.stripToNull(cashAndBankAccountAsset);
        this.cashAndBankAccountAsset = cashAndBankAccountAsset;
    }
    /**
     * @return Returns the adjustedMedicalExpense.
     */
    public String getAdjustedMedicalExpense() {
        return adjustedMedicalExpense;
    }
    /**
     * @param adjustedMedicalExpense The adjustedMedicalExpense to set.
     */
    public void setAdjustedMedicalExpense(String adjustedMedicalExpense) {
    	adjustedMedicalExpense = StringUtils.stripToNull(adjustedMedicalExpense);
        this.adjustedMedicalExpense = adjustedMedicalExpense;
    }
    
    /**
     * @return Returns the dependentInfoList.
     */
    public List getDependentInfoList() {
        return dependentInfoList;
    }
    /**
     * @param dependentInfoList The dependentInfoList to set.
     */
    public void setDependentInfoList(List dependentInfoList) {
        this.dependentInfoList = dependentInfoList;
    }
    /**
     * @return Returns the educationExpense.
     */
    public String getEducationExpense() {
        return educationExpense;
    }
    /**
     * @param educationExpense The educationExpense to set.
     */
    public void setEducationExpense(String educationExpense) {
    	educationExpense = StringUtils.stripToNull(educationExpense);
        this.educationExpense = educationExpense;
    }
    /**
     * @return Returns the netIncomeFromFarmRanchOrBusiness.
     */
    public String getNetIncomeFromFarmRanchOrBusiness() {
        return netIncomeFromFarmRanchOrBusiness;
    }
    /**
     * @param netIncomeFromFarmRanchOrBusiness The netIncomeFromFarmRanchOrBusiness to set.
     */
    public void setNetIncomeFromFarmRanchOrBusiness(
            String netIncomeFromFarmRanchOrBusiness) {
    	netIncomeFromFarmRanchOrBusiness = StringUtils.stripToNull(netIncomeFromFarmRanchOrBusiness);
        this.netIncomeFromFarmRanchOrBusiness = netIncomeFromFarmRanchOrBusiness;
    }
    /**
     * @return Returns the otherIncome.
     */
    public String getOtherIncome() {
        return otherIncome;
    }
    /**
     * @param otherIncome The otherIncome to set.
     */
    public void setOtherIncome(String otherIncome) {
    	otherIncome = StringUtils.stripToNull(otherIncome);
        this.otherIncome = otherIncome;
    }
    /**
     * @return Returns the otherPropertyAsset.
     */
    public String getOtherPropertyAsset() {
        return otherPropertyAsset;
    }
    /**
     * @param otherPropertyAsset The otherPropertyAsset to set.
     */
    public void setOtherPropertyAsset(String otherPropertyAsset) {
    	otherPropertyAsset = StringUtils.stripToNull(otherPropertyAsset);
        this.otherPropertyAsset = otherPropertyAsset;
    }
    /**
     * @return Returns the realPropertyAsset.
     */
    public String getRealPropertyAsset() {
        return realPropertyAsset;
    }
    /**
     * @param realPropertyAsset The realPropertyAsset to set.
     */
    public void setRealPropertyAsset(String realPropertyAsset) {
    	realPropertyAsset = StringUtils.stripToNull(realPropertyAsset);
        this.realPropertyAsset = realPropertyAsset;
    }
    /**
     * @return Returns the stocksAsset.
     */
    public String getStocksAsset() {
        return stocksAsset;
    }
    /**
     * @param stocksAsset The stocksAsset to set.
     */
    public void setStocksAsset(String stocksAsset) {
    	stocksAsset = StringUtils.stripToNull(stocksAsset);
        this.stocksAsset = stocksAsset;
    }
    /**
     * @return Returns the debt.
     */
    public String getDebt() {
        return debt;
    }
    /**
     * @param debt The debt to set.
     */
    public void setDebt(String debt) {
    	debt = StringUtils.stripToNull(debt);
        this.debt = debt;
    }
    
    /**
     * @return Returns the interestDividentAnuityIncome.
     */
    public String getInterestDividentAnuityIncome() {
        return interestDividentAnuityIncome;
    }
    /**
     * @param interestDividentAnuityIncome The interestDividentAnuityIncome to set.
     */
    public void setInterestDividentAnuityIncome(
            String interestDividentAnuityIncome) {
    	interestDividentAnuityIncome = StringUtils.stripToNull(interestDividentAnuityIncome);
        this.interestDividentAnuityIncome = interestDividentAnuityIncome;
    }
    /**
     * @return Returns the militaryRetirementIncome.
     */
    public String getMilitaryRetirementIncome() {
        return militaryRetirementIncome;
    }
    /**
     * @param militaryRetirementIncome The militaryRetirementIncome to set.
     */
    public void setMilitaryRetirementIncome(String militaryRetirementIncome) {
    	militaryRetirementIncome = StringUtils.stripToNull(militaryRetirementIncome);
        this.militaryRetirementIncome = militaryRetirementIncome;
    }
    /**
     * @return Returns the otherRetirementIncome.
     */
    public String getOtherRetirementIncome() {
        return otherRetirementIncome;
    }
    /**
     * @param otherRetirementIncome The otherRetirementIncome to set.
     */
    public void setOtherRetirementIncome(String otherRetirementIncome) {
    	otherRetirementIncome = StringUtils.stripToNull(otherRetirementIncome);
        this.otherRetirementIncome = otherRetirementIncome;
    }
    /**
     * @return Returns the railroadRetirementIncome.
     */
    public String getRailroadRetirementIncome() {
        return railroadRetirementIncome;
    }
    /**
     * @param railroadRetirementIncome The railroadRetirementIncome to set.
     */
    public void setRailroadRetirementIncome(String railroadRetirementIncome) {
    	railroadRetirementIncome = StringUtils.stripToNull(railroadRetirementIncome);
        this.railroadRetirementIncome = railroadRetirementIncome;
    }
    /**
     * @return Returns the socialSecurityIncome.
     */
    public String getSocialSecurityIncome() {
        return socialSecurityIncome;
    }
    /**
     * @param socialSecurityIncome The socialSecurityIncome to set.
     */
    public void setSocialSecurityIncome(String socialSecurityIncome) {
        this.socialSecurityIncome = StringUtils.stripToNull(socialSecurityIncome);
    }
    /**
     * @return Returns the unemploymentIncome.
     */
    public String getUnemploymentIncome() {
        return unemploymentIncome;
    }
    /**
     * @param unemploymentIncome The unemploymentIncome to set.
     */
    public void setUnemploymentIncome(String unemploymentIncome) {
        this.unemploymentIncome = StringUtils.stripToNull(unemploymentIncome);
    }
    /**
     * @return Returns the uSCivilServiceIncome.
     */
    public String getUSCivilServiceIncome() {
        return USCivilServiceIncome;
    }
    /**
     * @param civilServiceIncome The uSCivilServiceIncome to set.
     */
    public void setUSCivilServiceIncome(String civilServiceIncome) {
        USCivilServiceIncome = StringUtils.stripToNull(civilServiceIncome);
    }
    /**
     * @return Returns the workersCompIncome.
     */
    public String getWorkersCompIncome() {
        return workersCompIncome;
    }
    /**
     * @param workersCompIncome The workersCompIncome to set.
     */
    public void setWorkersCompIncome(String workersCompIncome) {
        this.workersCompIncome = StringUtils.stripToNull(workersCompIncome);
    }
    /**
     * @return Returns the spouseInfo.
     */
    public SpouseFinancialInfoBean getSpouseInfo() {
        return spouseInfo;
    }
    /**
     * @param spouseInfo The spouseInfo to set.
     */
    public void setSpouseInfo(SpouseFinancialInfoBean spouseInfo) {
        this.spouseInfo = spouseInfo;
    }
    /**
     * @return Returns the totalIncome.
     */
    public String getTotalEmploymentIncome() {
        return totalEmploymentIncome;
    }
    /**
     * @param totalIncome The totalIncome to set.
     */
    public void setTotalEmploymentIncome(String totalIncome) {
        this.totalEmploymentIncome = StringUtils.stripToNull(totalIncome);
    }
    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }
    /**
     * @param name The name to set.
     */
    public void setName(String name) {
        this.name = StringUtils.stripToNull(name);
    }
    /**
     * @return Returns the funeralBurialExpense.
     */
    public String getFuneralBurialExpense() {
        return funeralBurialExpense;
    }
    /**
     * @param funeralBurialExpense The funeralBurialExpense to set.
     */
    public void setFuneralBurialExpense(String funeralBurialExpense) {
        this.funeralBurialExpense = StringUtils.stripToNull(funeralBurialExpense);
    }
    /**
     * @return Returns the nonReimbMedicalExpense.
     */
    public String getNonReimbMedicalExpense() {
        return nonReimbMedicalExpense;
    }
    /**
     * @param nonReimbMedicalExpense The nonReimbMedicalExpense to set.
     */
    public void setNonReimbMedicalExpense(String nonReimbMedicalExpense) {
        this.nonReimbMedicalExpense = StringUtils.stripToNull(nonReimbMedicalExpense);
    }
    /**
     * @return Returns the displayName.
     */
    public String getDisplayName() {
        if(displayName == null && getName()!= null)
        {
            StringBuffer tname = new StringBuffer(getName());
            tname.append(" (Veteran)");
            displayName = tname.toString(); 
        }
        return displayName;
    }
    /**
     * @param displayName The displayName to set.
     */
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }
    
    
    //Dependent data
    
    /**
     * @return Returns the depAmtContributed.
     */
    public String getDepSSN(int index) {
        return (String)depSSN.get(index);
    }
    /**
     * @param depAmtContributed The depAmtContributed to set.
     */
    public void setDepSSN(int index, String ssn) {
        setElement(this.depSSN, index, ssn);
    }
    /**
     * @return Returns the depRelationshipCode
     */
    public String getDepRelationshipCode(int index) {
        return (String)depRelationshipCode.get(index);
    }
    /**
     * @param depRelationship The depRelationshipCode to set.
     */
    public void setDepRelationshipCode(int index, String relationshipCode) {
        setElement(this.depRelationshipCode, index, relationshipCode);
    }       
    /**
     * @return Returns the depRelationship.
     */
    public String getDepRelationship(int index) {
        return (String)depRelationship.get(index);
    }
    /**
     * @param depRelationship The depRelationship to set.
     */
    public void setDepRelationship(int index, String relationship) {
        setElement(this.depRelationship, index, relationship);
    }       
    /**
     * @return Returns the depGenderCode
     */
    public String getDepGenderCode(int index) {
        return (String)depGenderCode.get(index);
    }
    /**
     * @param gender - The depGenderCode to set.
     */
    public void setDepGenderCode(int index, String genderCode) {
        setElement(this.depGenderCode, index, genderCode);
    }           
    /**
     * @return Returns the depGender.
     */
    public String getDepGender(int index) {
        return (String)depGender.get(index);
    }
    /**
     * @param gender - The depGender to set.
     */
    public void setDepGender(int index, String gender) {
        setElement(this.depGender, index, gender);
    }       
    
    /**
     * @return Returns the depAmtContributed.
     */
    public String getDepAmtContributed(int index) {
        if(this.depAmtContributed!=null && this.depAmtContributed.size()>0){
            return (String)depAmtContributed.get(index);    
        }
        else
        {
            return null;
        }       
    }
    /**
     * @param depAmtContributed The depAmtContributed to set.
     */
    public void setDepAmtContributed(int index, String depAmtContributed) {
        setElement(this.depAmtContributed, index, StringUtils.stripToNull(depAmtContributed));
    }
    /**
     * @return Returns the depAttendedSchool.
     */
    public String getDepAttendedSchool(int index) {
        try
        {
            return (String)depAttendedSchool.get(index);
        }
        catch(Exception e)
        {
            return NULL_VALUE;
        }
    }
    /**
     * @param depAttendedSchool The depAttendedSchool to set.
     */
    public void setDepAttendedSchool(int index, String depAttendedSchool) {
        setElement(this.depAttendedSchool, index,depAttendedSchool);
    }
    /**
     * @return Returns the depCashAsset.
     */
    public String getDepCashAsset(int index) {
        return (String)depCashAsset.get(index);
    }
    /**
     * @param depCashAsset The depCashAsset to set.
     */
    public void setDepCashAsset(int index, String depCashAsset) {
        setElement(this.depCashAsset, index, StringUtils.stripToNull(depCashAsset));
    }
    /**
     * @return Returns the depContributedToSupport.
     */
    public String getDepContributedToSupport(int index) {
        try
        {
            return (String)depContributedToSupport.get(index);
            
        }
        catch(Exception e)
        {
            return NULL_VALUE;
        }
    }
    /**
     * @param depContributedToSupport The depContributedToSupport to set.
     */
    public void setDepContributedToSupport(int index, String depContributedToSupport) {
        setElement(this.depContributedToSupport, index, depContributedToSupport);
    }
    /**
     * @return Returns the depDebts.
     */
    public String getDepStocksAsset(int index) {
        return (String)depStocksAsset.get(index);
    }
    /**
     * @param depStocks The depStocks to set.
     */
    public void setDepStocksAsset(int index, String depStocksAsset) {
        setElement(this.depStocksAsset, index, StringUtils.stripToNull(depStocksAsset));
    }
    /**
     * @return Returns the depDisplayName.
     */
    public String getDepName(int index) {
        return (String)depName.get(index);
    }
    /**
     * @param depDisplayName The depDisplayName to set.
     */
    public void setDepName(int index, String depDisplayName) {
        setElement(this.depName, index, depDisplayName);
    }
    /**
     * @return Returns the depEduExpenses.
     */
    public String getDepEduExpenses(int index) {
        return (String)depEduExpenses.get(index);
    }
    /**
     * @param depEduExpenses The depEduExpenses to set.
     */
    public void setDepEduExpenses(int index,String depEduExpenses) {
        setElement(this.depEduExpenses, index, StringUtils.stripToNull(depEduExpenses));
    }
    /**
     * @return Returns the depEffectiveDate.
     */
    public String getDepEffectiveDate(int index) {
        return (String)depEffectiveDate.get(index);
    }
    /**
     * @param depEffectiveDate The depEffectiveDate to set.
     */
    public void setDepEffectiveDate(int index,String depEffectiveDate) {
        setElement(this.depEffectiveDate, index, StringUtils.stripToNull(depEffectiveDate));
    }
    /**
     * @return Returns the depFinacialsId.
     */
    public String getDepFinacialsId(int index) {
        return (String)depFinacialsId.get(index);
    }
    /**
     * @param depFinacialsId The depFinacialsId to set.
     */
    public void setDepFinacialsId(int index, String depFinacialsId) {
        setElement(this.depFinacialsId, index, depFinacialsId);
    }
    /**
     * @return Returns the depHasIncome.
     */
    public String getDepHasIncome(int index) {
        try
        {
            return (String)depHasIncome.get(index);
        }
        catch(Exception e)
        {
            return NULL_VALUE;
        }
    }
    /**
     * @param depHasIncome The depHasIncome to set.
     */
    public void setDepHasIncome(int index, String depHasIncome) {
        setElement(this.depHasIncome, index, depHasIncome);
    }
    /**
     * @return Returns the depInactiveDate.
     */
    public String getDepInactiveDate(int index) {
        return (String)depInactiveDate.get(index);
    }
    /**
     * @param depInactiveDate The depInactiveDate to set.
     */
    public void setDepInactiveDate(int index, String depInactiveDate) {
        setElement(this.depInactiveDate, index, StringUtils.stripToNull(depInactiveDate));
    }
    /**
     * @return Returns the depIncapableOfSelfSupport.
     */
    public String getDepIncapableOfSelfSupport(int index) {
        try
        {
            return (String)depIncapableOfSelfSupport.get(index);
        }
        catch(Exception e)
        {
            return NULL_VALUE;
        }
    }
    /**
     * @param depIncapableOfSelfSupport The depIncapableOfSelfSupport to set.
     */
    public void setDepIncapableOfSelfSupport(int index, String depIncapableOfSelfSupport) {
        setElement(this.depIncapableOfSelfSupport, index, depIncapableOfSelfSupport);
    }
    /**
     * @return Returns the depIncomeAvailableToPatient.
     */
    public String getDepIncomeAvailableToPatient(int index) {
        try
        {
            return (String)depIncomeAvailableToPatient.get(index);
        }
        catch(Exception e)
        {
            return NULL_VALUE;
        }
    }
    /**
     * @param depIncomeAvailableToPatient The depIncomeAvailableToPatient to set.
     */
    public void setDepIncomeAvailableToPatient(int index, String depIncomeAvailableToPatient) {
        setElement(this.depIncomeAvailableToPatient, index, depIncomeAvailableToPatient);
    }
    /**
     * @return Returns the depIncomeFromRanch.
     */
    public String getDepIncomeFromRanch(int index) {
        return (String)depIncomeFromRanch.get(index);
    }
    /**
     * @param depIncomeFromRanch The depIncomeFromRanch to set.
     */
    public void setDepIncomeFromRanch(int index, String depIncomeFromRanch) {
        setElement(this.depIncomeFromRanch, index, StringUtils.stripToNull(depIncomeFromRanch));
    }
    /**
     * @return Returns the depLivedWithPatient.
     */
    public String getDepLivedWithPatient(int index) {
        //TO DO: workaround for array out of bounds exception being thrown when "nd" is changed to nulls
        //need to use the yesnonodata list
        try
        {
            return (String)depLivedWithPatient.get(index);
        }
        catch(Exception e)
        {
            return NULL_VALUE;
        }
    }
    /**
     * @param depLivedWithPatient The depLivedWithPatient to set.
     */
    public void setDepLivedWithPatient(int index, String depLivedWithPatient) {
        setElement(this.depLivedWithPatient, index, depLivedWithPatient);
    }
    /**
     * @return Returns the depOtherAsset.
     */
    public String getDepOtherAsset(int index) {
        return (String)depOtherAsset.get(index);
    }
    /**
     * @param depOtherAsset The depOtherAsset to set.
     */
    public void setDepOtherAsset(int index, String depOtherAsset) {
        setElement(this.depOtherAsset, index, StringUtils.stripToNull(depOtherAsset));
    }
    /**
     * @return Returns the depOtherIncome.
     */
    public String getDepOtherIncome(int index) {
        return (String)depOtherIncome.get(index);
    }
    /**
     * @param depOtherIncome The depOtherIncome to set.
     */
    public void setDepOtherIncome(int index, String depOtherIncome) {
        setElement(this.depOtherIncome, index, StringUtils.stripToNull(depOtherIncome));
    }
    /**
     * @return Returns the depRealAsset.
     */
    public String getDepRealAsset(int index) {
        return (String)depRealAsset.get(index);
    }
    /**
     * @param depRealAsset The depRealAsset to set.
     */
    public void setDepRealAsset(int index, String depRealAsset) {
        setElement(this.depRealAsset, index, StringUtils.stripToNull(depRealAsset));
    }
    /**
     * @return Returns the depTotalIncome.
     */
    public String getDepTotalIncome(int index) {
        return (String)depTotalIncome.get(index);
    }
    /**
     * @param depTotalIncome The depTotalIncome to set.
     */
    public void setDepTotalIncome(int index, String depTotalIncome) {
        setElement(this.depTotalIncome, index, StringUtils.stripToNull(depTotalIncome));
    }
    /**
     * @return Returns the depValid.
     */
    public String getDepValid(int index) {
        return (String)depValid.get(index);
    }
    /**
     * @param depValid The depValid to set.
     */
    public void setDepValid(int index, String depValid) {
        setElement(this.depValid, index, depValid);
    }
    /**
     * @return Returns the depInterestDividentAnuityIncome.
     */
    public String getDepInterestDividentAnuityIncome(int index) {
        return (String)depInterestDividentAnuityIncome.get(index);
    }
    /**
     * @param depInterestDividentAnuityIncome The depInterestDividentAnuityIncome to set.
     */
    public void setDepInterestDividentAnuityIncome(int index,
            String depInterestDividentAnuityIncome) {
        setElement(this.depInterestDividentAnuityIncome, index, StringUtils.stripToNull(depInterestDividentAnuityIncome));
    }
    /**
     * @return Returns the depMilitaryRetirementIncome.
     */
    public String getDepMilitaryRetirementIncome(int index) {
        return (String)depMilitaryRetirementIncome.get(index);
    }
    /**
     * @param depMilitaryRetirementIncome The depMilitaryRetirementIncome to set.
     */
    public void setDepMilitaryRetirementIncome(int index, String depMilitaryRetirementIncome) {
        setElement(this.depMilitaryRetirementIncome, index, StringUtils.stripToNull(depMilitaryRetirementIncome));
    }
    /**
     * @return Returns the depOtherRetirementIncome.
     */
    public String getDepOtherRetirementIncome(int index) {
        return (String)depOtherRetirementIncome.get(index);
    }
    /**
     * @param depOtherRetirementIncome The depOtherRetirementIncome to set.
     */
    public void setDepOtherRetirementIncome(int index, String depOtherRetirementIncome) {
        setElement(this.depOtherRetirementIncome, index, StringUtils.stripToNull(depOtherRetirementIncome));
    }
    /**
     * @return Returns the depRailroadRetirementIncome.
     */
    public String getDepRailroadRetirementIncome(int index) {
        return (String)depRailroadRetirementIncome.get(index);
    }
    /**
     * @param depRailroadRetirementIncome The depRailroadRetirementIncome to set.
     */
    public void setDepRailroadRetirementIncome(int index, String depRailroadRetirementIncome) {
        setElement(this.depRailroadRetirementIncome, index, StringUtils.stripToNull(depRailroadRetirementIncome));
    }
    /**
     * @return Returns the depSocialSecurityIncome.
     */
    public String getDepSocialSecurityIncome(int index) {
        return (String)depSocialSecurityIncome.get(index);
    }
    /**
     * @param depSocialSecurityIncome The depSocialSecurityIncome to set.
     */
    public void setDepSocialSecurityIncome(int index, String depSocialSecurityIncome) {
        setElement(this.depSocialSecurityIncome, index, StringUtils.stripToNull(depSocialSecurityIncome));
    }
    /**
     * @return Returns the depUnemploymentIncome.
     */
    public String getDepUnemploymentIncome(int index) {
        return (String)depUnemploymentIncome.get(index);
    }
    /**
     * @param depUnemploymentIncome The depUnemploymentIncome to set.
     */
    public void setDepUnemploymentIncome(int index, String depUnemploymentIncome) {
        setElement(this.depUnemploymentIncome, index, StringUtils.stripToNull(depUnemploymentIncome));
    }
    /**
     * @return Returns the depUSCivilServiceIncome.
     */
    public String getDepUSCivilServiceIncome(int index) {
        return (String)depUSCivilServiceIncome.get(index);
    }
    /**
     * @param depUSCivilServiceIncome The depUSCivilServiceIncome to set.
     */
    public void setDepUSCivilServiceIncome(int index, String depUSCivilServiceIncome) {
        setElement(this.depUSCivilServiceIncome, index, StringUtils.stripToNull(depUSCivilServiceIncome));
    }
    /**
     * @return Returns the depWorkersCompIncome.
     */
    public String getDepWorkersCompIncome(int index) {
        return (String)depWorkersCompIncome.get(index);
    }
    /**
     * @param depWorkersCompIncome The depWorkersCompIncome to set.
     */
    public void setDepWorkersCompIncome(int index, String depWorkersCompIncome) {
        setElement(this.depWorkersCompIncome, index, StringUtils.stripToNull(depWorkersCompIncome));
    }
    /**
     * @return Returns the depDisplaySSN.
     */
    public String getDepDisplaySSN(int index) {
        return (String)depDisplaySSN.get(index);
    }
    /**
     * @param depDisplaySSN The depDisplaySSN to set.
     */
    public void setDepDisplaySSN(int index, String depDisplaySSN) {
        setElement(this.depDisplaySSN, index, depDisplaySSN);
    }
    /**
     * @return Returns the depAmtContribu =
     */
    public List getDepAmtContributedList() {
        return depAmtContributed;
    }
    /**
     * @param depAmtContributedList The depAmtContributedList to set.
     */
    public void setDepAmtContributedList(List depAmtContributedList) {
        this.depAmtContributed = depAmtContributedList;
    }
    /**
     * @return Returns the depAttendedSchoolList.
     */
    public List getDepAttendedSchoolList() {
        return depAttendedSchool;
    }
    /**
     * @param depAttendedSchoolList The depAttendedSchoolList to set.
     */
    public void setDepAttendedSchoolList(List depAttendedSchoolList) {
        this.depAttendedSchool = depAttendedSchoolList;
    }
    /**
     * @return Returns the depCashAssetList.
     */
    public List getDepCashAssetList() {
        return depCashAsset;
    }
    /**
     * @param depCashAssetList The depCashAssetList to set.
     */
    public void setDepCashAssetList(List depCashAssetList) {
        this.depCashAsset = depCashAssetList;
    }
    /**
     * @return Returns the depContributedToSupportList.
     */
    public List getDepContributedToSupportList() {
        return depContributedToSupport;
    }
    /**
     * @param depContributedToSupportList The depContributedToSupportList to set.
     */
    public void setDepContributedToSupportList(List depContributedToSupportList) {
        this.depContributedToSupport = depContributedToSupportList;
    }
    /**
     * @return Returns the depDebtsList.
     */
    public List getDepStocksAssetList() {
        return depStocksAsset;
    }
    /**
     * @param depStocksAssetList The depStocksAssetList to set.
     */
    public void setDepStocksAssetList(List depStocksList) {
        this.depStocksAsset = depStocksList;
    }
    /**
     * @return Returns the depNameList.
     */
    public List getDepNameList() {
        return depName;
    }
    /**
     * @param depDisplayNameList The depDisplayNameList to set.
     */
    public void setDepNameList(List depDisplayNameList) {
        this.depName = depDisplayNameList;
    }
    /**
     * @return Returns the depEduExpensesList.
     */
    public List getDepEduExpensesList() {
        return depEduExpenses;
    }
    /**
     * @param depEduExpensesList The depEduExpensesList to set.
     */
    public void setDepEduExpensesList(List depEduExpensesList) {
        this.depEduExpenses = depEduExpensesList;
    }
    /**
     * @return Returns the depEffectiveDateList.
     */
    public List getDepEffectiveDateList() {
        return depEffectiveDate;
    }
    /**
     * @param depEffectiveDateList The depEffectiveDateList to set.
     */
    public void setDepEffectiveDateList(List depEffectiveDateList) {
        this.depEffectiveDate = depEffectiveDateList;
    }
    /**
     * @return Returns the depFinacialsIdList.
     */
    public List getDepFinacialsIdList() {
        return depFinacialsId;
    }
    /**
     * @param depFinacialsIdList The depFinacialsIdList to set.
     */
    public void setDepFinacialsIdList(List depFinacialsIdList) {
        this.depFinacialsId = depFinacialsIdList;
    }
    /**
     * @return Returns the depHasIncomeList.
     */
    public List getDepHasIncomeList() {
        return depHasIncome;
    }
    /**
     * @param depHasIncomeList The depHasIncomeList to set.
     */
    public void setDepHasIncomeList(List depHasIncomeList) {
        this.depHasIncome = depHasIncomeList;
    }
    /**
     * @return Returns the depInactiveDateList.
     */
    public List getDepInactiveDateList() {
        return depInactiveDate;
    }
    /**
     * @param depInactiveDateList The depInactiveDateList to set.
     */
    public void setDepInactiveDateList(List depInactiveDateList) {
        this.depInactiveDate = depInactiveDateList;
    }
    /**
     * @return Returns the depIncapableOfSelfSupportList.
     */
    public List getDepIncapableOfSelfSupportList() {
        return depIncapableOfSelfSupport;
    }
    /**
     * @param depIncapableOfSelfSupportList The depIncapableOfSelfSupportList to set.
     */
    public void setDepIncapableOfSelfSupportList(
            List depIncapableOfSelfSupportList) {
        this.depIncapableOfSelfSupport = depIncapableOfSelfSupportList;
    }
    /**
     * @return Returns the depIncomeAvailableToPatientList.
     */
    public List getDepIncomeAvailableToPatientList() {
        return depIncomeAvailableToPatient;
    }
    /**
     * @param depIncomeAvailableToPatientList The depIncomeAvailableToPatientList to set.
     */
    public void setDepIncomeAvailableToPatientList(
            List depIncomeAvailableToPatientList) {
        this.depIncomeAvailableToPatient = depIncomeAvailableToPatientList;
    }
    /**
     * @return Returns the depIncomeFromRanchList.
     */
    public List getDepIncomeFromRanchList() {
        return depIncomeFromRanch;
    }
    /**
     * @param depIncomeFromRanchList The depIncomeFromRanchList to set.
     */
    public void setDepIncomeFromRanchList(List depIncomeFromRanchList) {
        this.depIncomeFromRanch = depIncomeFromRanchList;
    }
    /**
     * @return Returns the depLivedWithPatientList.
     */
    public List getDepLivedWithPatientList() {
        return depLivedWithPatient;
    }
    /**
     * @param depLivedWithPatientList The depLivedWithPatientList to set.
     */
    public void setDepLivedWithPatientList(List depLivedWithPatientList) {
        this.depLivedWithPatient = depLivedWithPatientList;
    }
    /**
     * @return Returns the depOtherAssetList.
     */
    public List getDepOtherAssetList() {
        return depOtherAsset;
    }
    /**
     * @param depOtherAssetList The depOtherAssetList to set.
     */
    public void setDepOtherAssetList(List depOtherAssetList) {
        this.depOtherAsset = depOtherAssetList;
    }
    /**
     * @return Returns the depOtherIncomeList.
     */
    public List getDepOtherIncomeList() {
        return depOtherIncome;
    }
    /**
     * @param depOtherIncomeList The depOtherIncomeList to set.
     */
    public void setDepOtherIncomeList(List depOtherIncomeList) {
        this.depOtherIncome = depOtherIncomeList;
    }
    /**
     * @return Returns the depRealAssetList.
     */
    public List getDepRealAssetList() {
        return depRealAsset;
    }
    /**
     * @param depRealAssetList The depRealAssetList to set.
     */
    public void setDepRealAssetList(List depRealAssetList) {
        this.depRealAsset = depRealAssetList;
    }
    /**
     * @return Returns the depTotalIncomeList.
     */
    public List getDepTotalIncomeList() {
        return depTotalIncome;
    }
    /**
     * @param depTotalIncomeList The depTotalIncomeList to set.
     */
    public void setDepTotalIncomeList(List depTotalIncomeList) {
        this.depTotalIncome = depTotalIncomeList;
    }
    /**
     * @return Returns the depValidList.
     */
    public List getDepValidList() {
        return depValid;
    }
    /**
     * @param depValidList The depValidList to set.
     */
    public void setDepValidList(List depValidList) {
        this.depValid = depValidList;
    }
    /**
     * @return Returns the depRelationshipList.
     */
    public List getDepRelationshipList() {
        return depRelationship;
    }
    /**
     * @param depRelationshipList The depRelationshipList to set.
     */
    public void setDepRelationshipList(List depRelationshipList) {
        this.depRelationship = depRelationshipList;
    }
    /**
     * @return Returns the depGenderList.
     */
    public List getDepGenderList() {
        return depGender;
    }
    /**
     * @param depRelationshipList The depGenderList to set.
     */
    public void setDepGenderList(List depGenderList) {
        this.depGender = depGenderList;
    }
    /**
     * @return Returns the depSSNList.
     */
    public List getDepSSNList() {
        return depSSN;
    }
    /**
     * @param depSSNList The depSSNList to set.
     */
    public void setDepSSNList(List depSSNList) {
        this.depSSN = depSSNList;
    }
    
    /**
     * @return Returns the depInterestDividentAnuityIncome.
     */
    public List getDepInterestDividentAnuityIncomeList() {
        return depInterestDividentAnuityIncome;
    }
    /**
     * @param depInterestDividentAnuityIncome The depInterestDividentAnuityIncome to set.
     */
    public void setDepInterestDividentAnuityIncomeList(
            List depInterestDividentAnuityIncome) {
        this.depInterestDividentAnuityIncome = depInterestDividentAnuityIncome;
    }
    /**
     * @return Returns the depMilitaryRetirementIncome.
     */
    public List getDepMilitaryRetirementIncomeList() {
        return depMilitaryRetirementIncome;
    }
    /**
     * @param depMilitaryRetirementIncome The depMilitaryRetirementIncome to set.
     */
    public void setDepMilitaryRetirementIncomeList(List depMilitaryRetirementIncome) {
        this.depMilitaryRetirementIncome = depMilitaryRetirementIncome;
    }
    /**
     * @return Returns the depOtherRetirementIncome.
     */
    public List getDepOtherRetirementIncomeList() {
        return depOtherRetirementIncome;
    }
    /**
     * @param depOtherRetirementIncome The depOtherRetirementIncome to set.
     */
    public void setDepOtherRetirementIncomeList(List depOtherRetirementIncome) {
        this.depOtherRetirementIncome = depOtherRetirementIncome;
    }
    /**
     * @return Returns the depRailroadRetirementIncome.
     */
    public List getDepRailroadRetirementIncomeList() {
        return depRailroadRetirementIncome;
    }
    /**
     * @param depRailroadRetirementIncome The depRailroadRetirementIncome to set.
     */
    public void setDepRailroadRetirementIncomeList(List depRailroadRetirementIncome) {
        this.depRailroadRetirementIncome = depRailroadRetirementIncome;
    }
    /**
     * @return Returns the depSocialSecurityIncome.
     */
    public List getDepSocialSecurityIncomeList() {
        return depSocialSecurityIncome;
    }
    /**
     * @param depSocialSecurityIncome The depSocialSecurityIncome to set.
     */
    public void setDepSocialSecurityIncomeList(List depSocialSecurityIncome) {
        this.depSocialSecurityIncome = depSocialSecurityIncome;
    }
    /**
     * @return Returns the depUnemploymentIncome.
     */
    public List getDepUnemploymentIncomeList() {
        return depUnemploymentIncome;
    }
    /**
     * @param depUnemploymentIncome The depUnemploymentIncome to set.
     */
    public void setDepUnemploymentIncomeList(List depUnemploymentIncome) {
        this.depUnemploymentIncome = depUnemploymentIncome;
    }
    /**
     * @return Returns the depUSCivilServiceIncome.
     */
    public List getDepUSCivilServiceIncomeList() {
        return depUSCivilServiceIncome;
    }
    /**
     * @param depUSCivilServiceIncome The depUSCivilServiceIncome to set.
     */
    public void setDepUSCivilServiceIncomeList(List depUSCivilServiceIncome) {
        this.depUSCivilServiceIncome = depUSCivilServiceIncome;
    }
    /**
     * @return Returns the depWorkersCompIncome.
     */
    public List getDepWorkersCompIncomeList() {
        return depWorkersCompIncome;
    }
    /**
     * @param depWorkersCompIncome The depWorkersCompIncome to set.
     */
    public void setDepWorkersCompIncomeList(List depWorkersCompIncome) {
        this.depWorkersCompIncome = depWorkersCompIncome;
    }
    /**
     * @return Returns the depDisplaySSN.
     */
    public List getDepDisplaySSNList() {
        return depDisplaySSN;
    }
    /**
     * @param depDisplaySSN The depDisplaySSN to set.
     */
    public void setDepDisplaySSNList(List depDisplaySSN) {
        this.depDisplaySSN = depDisplaySSN;
    }
    
    /**
     * @return Returns the depFinacialsHashCode.
     */
    public String getDepFinacialsHashCode(int index) {
        return (String)depFinacialsHashCode.get(index);
    }
    
    /**
     * @return Returns the depFinacialsHashCodeList.
     */
    public List getDepFinacialsHashcodeList() {
        return depFinacialsHashCode;
    }
    
    /**
     * @param depFinacialsHashCode The depFinacialsHashCode to set.
     */
    public void setDepFinacialsHashCode(int index, String depFinacialsHashCode) {
        setElement(this.depFinacialsHashCode, index, depFinacialsHashCode);
    }
    
    /**
     * @return Returns the pendingAdjudication.
     */
    public boolean isPendingAdjudication() {
        return this.pendingAdjudication;
    }

    /**
     * @param pendingAdjudication The pendingAdjudication to set.
     */
    public void setPendingAdjudication(boolean pendingAdjudication) {
        this.pendingAdjudication = pendingAdjudication;
    }

    public void addDependent()
    {
        depFinacialsId.add("");
        depName.add("");
        depSSN.add("");
        depRelationshipCode.add("");
        depRelationship.add("");
        depGenderCode.add("");
        depGender.add("");
        depEffectiveDate.add("");
        depValid.add("");
        depInactiveDate.add("");
        depLivedWithPatient.add("");
        depContributedToSupport.add("");
        depAmtContributed.add("");
        depHasIncome.add("");
        depIncomeAvailableToPatient.add("");
        depAttendedSchool.add("");
        depIncapableOfSelfSupport.add("");
        depTotalIncome.add("");
        depIncomeFromRanch.add("");
        depOtherIncome.add("");
        depEduExpenses.add("");
        depCashAsset.add("");
        depRealAsset.add("");
        depOtherAsset.add("");
        depStocksAsset.add("");
        depUSCivilServiceIncome.add("");
        depInterestDividentAnuityIncome.add("");    
        depUnemploymentIncome.add(""); 
        depSocialSecurityIncome.add("");
        depMilitaryRetirementIncome.add("");
        depRailroadRetirementIncome.add("");
        depOtherRetirementIncome.add("");
        depWorkersCompIncome.add("");
        depDisplaySSN.add("");
        depFinacialsHashCode.add("");
    }
    
    /**
     * Sets an element at the specific index. If the index is greater than the size of the list, 
     * adds nulls to the list to make up the size.
     * 
     * @param list the list object
     * @param index the index
     * @param value the value to be set
     */
    public void setElement(List list, int index, Object value)
    {
        for(int i=list.size(); i<=index; i++)
        {
            list.add(null);
        }
        list.set(index,value);
    }


}
