/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.ui.conversion;

// Java Classes
import gov.va.med.fw.conversion.ConversionServiceImpl;
import gov.va.med.fw.model.lookup.Lookup;

/**
 * Common shared methods of the conversion service.
 *
 * @author DNS   chenj2
 */
public class CommonConversionServiceImpl extends ConversionServiceImpl
{
  //  private LookupService lookupService;
    public final static String Y  = "y";
    public final static String N  = "n";
    public final static String ND    = "nd";

    /**
     * Default constructor.
     */
    public CommonConversionServiceImpl()
    {
    }

	/**
	 * Convenient method to avoid null checks in the code
	 */
    public String getLookupCode(Lookup lookup) {
    	return (lookup == null ? null : lookup.getCode());
    }

    public String getYesNoNoData(Boolean flag) {
        if(flag == null) return ND;
        return (flag.booleanValue() == true) ? Y : N;
    }
}