/*****************************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.esr.common.rule.service.impl;

// Framework classes
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.rule.data.EgtInputData;
import gov.va.med.esr.common.rule.service.EGTRuleService;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;

import org.apache.commons.lang.Validate;

/**
 * Project: Common
 * 
 * @author DNS   LEV
 * @version 1.0
 */
public class EGTRuleServiceImpl extends AbstractRuleValidationServiceAwareImpl implements
      EGTRuleService {

   private static final long serialVersionUID = 6200609426168999185L;

   private String egtRuleParameters = null;

   private String manageEgtRuleParameters = null;

   public EGTRuleServiceImpl() {
      super();
   }

   /**
    * @see gov.va.med.esr.common.rule.service.EGTRuleService#manageEGT(gov.va.med.esr.common.model.ee.EGTSetting,
    *      gov.va.med.esr.common.model.ee.EGTSetting)
    */
   public EGTSetting manageEGT(EGTSetting incoming, EGTSetting onFile)
         throws ServiceException {
      Validate.notNull(incoming, "Incoming EGT setting must not be null");
      ValidationMessages messages = this.getRuleValidationService().validateEgtSetting(
            incoming, onFile);
      if( messages != null && !messages.isEmpty() ) {
         throw new ValidationServiceException(messages);
      }
      EgtInputData data = new EgtInputData(incoming, onFile);
      this
            .invokeRuleFlow(this.getRuleParameters(this.getManageEgtRuleParameters()),
                  data);
      return onFile;
   }

   /**
    * @see gov.va.med.esr.common.rule.service.EGTRuleService#processEGT(gov.va.med.esr.common.model.ee.EGTSetting)
    */
   public EGTSetting processEGT(EGTSetting incoming, EGTSetting egtOnFile)
         throws ServiceException {
      Validate.notNull(incoming, "Incoming EGTSetting must not be null");

      EgtInputData data = new EgtInputData(incoming, egtOnFile); //
      this.invokeRuleFlow(this.getRuleParameters(getEgtRuleParameters()), data);
      return egtOnFile;
   }

   /**
    * @see gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl#afterPropertiesSet()
    */
   public void afterPropertiesSet() throws Exception {
      super.afterPropertiesSet();
      Validate.notNull(this.egtRuleParameters, "egtRuleParameters property is required");
      Validate.notNull(this.manageEgtRuleParameters,
            "manageEgtRuleParameters property is required");
   }

   /**
    * @return Returns the egtRuleParameters.
    */
   public String getEgtRuleParameters() {
      return egtRuleParameters;
   }

   /**
    * @param egtRuleParameters
    *           The egtRuleParameters to set.
    */
   public void setEgtRuleParameters(String egtRuleParameters) {
      this.egtRuleParameters = egtRuleParameters;
   }

   /**
    * @return Returns the manageEgtRuleParameters.
    */
   public String getManageEgtRuleParameters() {
      return manageEgtRuleParameters;
   }

   /**
    * @param manageEgtRuleParameters
    *           The manageEgtRuleParameters to set.
    */
   public void setManageEgtRuleParameters(String manageEgtRuleParameters) {
      this.manageEgtRuleParameters = manageEgtRuleParameters;
   }
}
