/*****************************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.esr.common.rule.service.impl;

// Java classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.esr.common.rule.service.ClinicalDeterminationRuleService;
import gov.va.med.fw.service.ServiceException;

import org.apache.commons.lang.Validate;

/**
 * Project: Common
 *
 * @author Muddaiah Ranga
 * @version 1.0
 */
public class ClinicalDeterminationRuleServiceImpl extends
      AbstractRuleValidationServiceAwareImpl implements ClinicalDeterminationRuleService {

   // An instance of serialVersionUID
   private static final long serialVersionUID = -1455258106175382818L;

   private String clinicalDeterminationRuleParameters = null;

   /**
    * A default constructor
    */
   public ClinicalDeterminationRuleServiceImpl() {
      super();
   }

   public Person processClinicalDetermination(Person incoming, Person onFile,
	         VAFacility sendingFacility, String caller) throws ServiceException {
	      Validate.notNull(onFile, "A incoming must person not be null ");

	      return doClinicalDetermination(incoming, onFile, sendingFacility, caller);
	   }

   private Person doClinicalDetermination(Person incoming, Person onFile,
         VAFacility sendingFacility, String caller) throws ServiceException {
      Validate.notNull(onFile, "A current veteran must not be null ");

      Person pristine = this.getPristinePerson(onFile);

      //CCR12710
      if (logger.isDebugEnabled()) {
          logger.debug("ClinicalDetermRuleServiceImpl doClinicalDetermination : incoming" + incoming + " onfile: " + onFile);
		}

      // Invoke a rule flow to calculate period of service
      this.invokeRuleFlow( this.getRuleParameters( this.getClinicalDeterminationRuleParameters() ),
                           new PersonInputData( incoming, onFile, pristine, sendingFacility, UI.equals(caller) ) );

      return onFile;
   }

   /**
    * @return Returns the clinicalDeterminationRuleParameters.
    */
   public String getClinicalDeterminationRuleParameters() {
      return clinicalDeterminationRuleParameters;
   }

   /**
    * @param clinialDeterminationRuleParameters
    *           The clinialDeterminationRuleParameters to set.
    */
   public void setClinicalDeterminationRuleParameters(
         String clinicalDeterminationRuleParameters) {
      this.clinicalDeterminationRuleParameters = clinicalDeterminationRuleParameters;
   }

   /**
    * @see gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl#afterPropertiesSet()
    */
   public void afterPropertiesSet() throws Exception {
      super.afterPropertiesSet();
      Validate.notNull(this.clinicalDeterminationRuleParameters,"A clinical determination rule parameters is required");
   }
}