/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.service;

// Java classes
import java.io.Serializable;
import java.util.List;

// Library classes

// Framework classes
import gov.va.med.fw.validation.ValidationMessages;

// EDB classes
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.Document;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;

// Framework classes
import gov.va.med.fw.service.ServiceException;

/**
 * <br>Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public interface RuleValidationService extends Serializable {
   
   /**
    * @param person
    * @return
    */
   public ValidationMessages validateDemographic( Person person, boolean isDataFromGUI)
   throws ServiceException;

   /**
    * @param msc
    * @return
    */
   public ValidationMessages validateCombatEpisode(CombatEpisode ce, 
                                                   Person incoming, 
                                                   Person pristine, 
                                                   boolean isDataFromGUI  ) throws ServiceException;
   
   /**
    * @param msc
    * @return
    */
   public ValidationMessages validateConflictExperience(ConflictExperience ce, 
   														Person incoming, 
   														Person pristine, 
   														boolean isDataFromGUI  ) throws ServiceException;
   
   /**
    * @param ms
    * @return
    */
   public ValidationMessages validateMS(MilitaryService ms, 
   										Person incoming, 
   										Person pristine, 
   										boolean isDataFromGUI,  
                                        String useCaseName) throws ServiceException;
   
   /**
    * @param mse
    * @return
    */
   public ValidationMessages validateMSE( MilitaryServiceEpisode mse, 
   												   Person incoming, 
   												   Person pristine, 
   												   boolean isDataFromGUI  ) throws ServiceException;
   
   /**
    * 
    * @param incomeYear
    * @param incoming
    * @param onFile
    * @param pristine
    * @param isDemographicUpdate
    * @param isDataFromGUI
    * @return
    * @throws ServiceException
    */
   public ValidationMessages validateVeteranFinancials(Integer incomeYear, Person incoming, Person onFile,Person pristine,boolean isDemographicUpdate,boolean isDataFromGUI) throws ServiceException;

   
   /**
    * 
    * @param incomeYear
    * @param incoming
    * @param onFile
    * @param pristine
    * @param isDemographicUpdate
    * @param isDataFromGUI
    * @return
    * @throws ServiceException
    */
   public ValidationMessages validateSpouseFinancials(Integer incomeYear, SpouseFinancials spouseFinancials, Person incoming, Person onFile, boolean isDemographicUpdate,boolean isDataFromGUI) throws ServiceException;
   
   /**
    * 
    * @param incomeYear
    * @param dependentFinancials
    * @param incoming
    * @param onFile
    * @param isDemographicUpdate
    * @param isDataFromGUI
    * @return
    * @throws ServiceException
    */
   public ValidationMessages validateDependentFinancials(Integer incomeYear,DependentFinancials dependentFinancials,Person incoming, Person onFile,boolean isDemographicUpdate,boolean isDataFromGUI) throws ServiceException;
   
   /**
    * 
    * @param privateInsurance
    * @return
    */
   public ValidationMessages validateInsurancePolicy( InsurancePolicy insurance, 
   																   Person result, 
   																   Person pristine, 
   																   boolean isDataFromGUI ) throws ServiceException;
   
   /**
    * 
    * @param association
    * @return
    */
   public ValidationMessages validateAssociation( Association association, Person onFile, Person pristine, boolean isDataFromGUI ) throws ServiceException;
   

   /**
    * 
    * @param incoming
    * @param onFile
    * @param pristine
    * @param isDataFromGUI
    * @return
    * @throws ServiceException
    */
   public ValidationMessages validateReceivedEnrollment(Person incoming, Person onFile, Person pristine, boolean isDataFromGUI)
            throws ServiceException;
   
   /**
    * Validate the ineligible from a message or UI
    * 
    * @param incoming
    * @param isDataFromGUI
    * @return
    * @throws ServiceException
    */
   public ValidationMessages validateIneligibility(Person incoming, boolean isDataFromGUI) throws ServiceException;
   

   /**
    * Validate the POW info from UI
    * 
    * @param powEpisode
    * @param incoming
    * @param isDataFromGUI
    * @return
    * @throws ServiceException
    */
   public ValidationMessages validatePOW(POWEpisode powEpisode, Person incoming, boolean isDataFromGUI)
            throws ServiceException;   


   /**
    * Validate a letter mailing
    * 
    * @param letterMailing
    * @param incoming
    * @return
    * @throws ServiceException
    */
   public ValidationMessages validateLetterMailing(CommsLogEntry letterMailing, Person incoming)
           throws ServiceException;    
   
   /**
    * Validate a registry
    * 
    * @param registry
    * @param isDataFromGUI
    * @return
    * @throws ServiceException
    */
   public ValidationMessages validateRegistry(Registry registry,boolean isDataFromGUI)
           throws ServiceException; 
   
   /**
    * Validate a registry
    * 
    * @param registry
    * @param document
    * @param isDataFromGUI
    * @return
    * @throws ServiceException
    */
   public ValidationMessages validateRegistryDocument(Registry registry,Document document,boolean isDataFromGUI)
           throws ServiceException;

   /**
    * Validate a letter send request.
    * 
    * @param person
    * @param formNumber
    * @param workflowCaseId
    * @param mailType
    * @param override
    * @param logs
    * @param categoryType
    * @param context
    * 
    * @return
    * @throws ServiceException
    */
   public ValidationMessages validateLetterSendRequest(Person person,
           ComLetterTemplateType formNumber, String workflowCaseId, LetterTriggerEvent.MailType mailType,
            Boolean override, List logs, String categoryType, String context) throws ServiceException;   

   /**
    * Validate a ph document.
    * 
    * @param purpleHeartDocument
    * @param incoming
    * @param isDataFromGUI
    * @return
    * @throws ServiceException
    */
   public ValidationMessages validatePurpleHeartDocument(PurpleHeartDocument purpleHeartDocument, Person incoming, boolean isDataFromGUI)
       throws ServiceException;   
   
   /**
    * Validate the EGT setting.
    * 
    * @param egtSetting
    * @param onFile
    * @return
    * @throws ServiceException
    */
   public ValidationMessages validateEgtSetting(EGTSetting egtSetting, EGTSetting onFile) throws ServiceException;
   
   /**
    * Validate person's Identity Traits.
    * 
    * @param person
    * @param isDataFromGUI
    * @return
    * @throws ServiceException
    */
   public ValidationMessages validateIdentityTraits( Person person, boolean isDataFromGUI) throws ServiceException;   
}