/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.service;

//Java classes
import java.io.Serializable;

// Framework classes
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.fw.service.ServiceException;


import gov.va.med.esr.service.LoadRegistryResult;


/**
 * Registry rule service interface.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public interface RegistryRuleService extends Serializable {
    
    /**
     * Manages the incoming registry obbject.
     * 
     * @param incoming the incoming registry object.
     * @param onFile the on file registry object or new registry object
     * @return
     * @throws ServiceException
     */
    public Registry manageRegistry(Registry incoming, Registry onFile) throws ServiceException;

    /**
     * Process registry from batch process
     * 
     * @param incoming
     * @param onFile
     * @param result
     * @return
     * @throws ServiceException
     */
    public Registry processRegistry(Registry incoming, Registry onFile, LoadRegistryResult result) throws ServiceException; 
    
    /**
     * Links the PH/POW/SHAD to the registry.
     * 
     * @param incoming
     * @param onFile
     * @param registries
     * @param incomingPerson
     * @param onFilePerson
     * @param registryType
     * @param isFromUI
     * @throws ServiceException
     */
    public void linkPersonRegistry(Registry incoming, Registry onFile, Person incomingPerson, Person onFilePerson, RegistryType registryType,boolean isFromUI)throws ServiceException;
   
}
