/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.service;

//Java classes
import java.io.Serializable;

// Framework classes
import gov.va.med.fw.service.ServiceException;

// EDB classes
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.clock.Clock;

/**
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public interface PurpleHeartRuleService extends Serializable 
{
    /**
     * Process the Purple Heart data for the UI clent.
     *  
     * @param incoming the updated incoming person
     * @param onFile the onfile person
     * @return the updated person
     * @throws ServiceException
     */
    public Person managePurpleHeart(Person incoming, Person onFile) throws ServiceException;
    
    /**
     * Process the Purple Heart data for the Clock Proces clent.
     * 
     * @param incoming
     * @param onFile
     * @param clockType
     * @return
     * @throws ServiceException
     */
    public Person managePurpleHeart(Person incoming, Person onFile, Clock.Type clockType) throws ServiceException;    
    
   /**
    * Process the Purple Heart data for message cleant.
    *  
    * @param incoming the updated incoming person
    * @param onFile the onfile person
    * @param verificationInfo verification info
    * @return the updated person
    * @throws ServiceException
    */
   public Person processPurpleHeart(Person incoming, Person onFile, VerificationInfo verificationInfo) throws ServiceException;
   /**
    * Process the Purple Heart data for message cleant.
    *  
    * @param incoming the updated incoming person
    * @param onFile the onfile person
    * @param verificationInfo verification info
    * @param VAFacility sendingFacility
    * @return the updated person
    * @throws ServiceException
    */
   public Person processPurpleHeart(Person incoming, Person onFile, VerificationInfo verificationInfo, VAFacility sendingFacility) throws ServiceException;
   /**
    * Process the Purple Heart data for message cleant.
    *  
    * @param incoming the updated incoming person
    * @param onFile the onfile person
    * @param verificationInfo verification info
    * @param VAFacility sendingFacility
    * @param String caller 
    * @return the updated person
    * @throws ServiceException
    */
   public Person processPurpleHeart(Person incoming, Person onFile, VerificationInfo verificationInfo, VAFacility sendingFacility, String caller) throws ServiceException;
}