/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.service;

// Java classes
import java.io.Serializable;

// Library classes

// Framework classes
import gov.va.med.fw.service.ServiceException;

// EDB classes
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public interface ProcessVBARuleService extends Serializable {

   /** Processes VBA data of a person from a site's ORUZ07 message
    *
    * @param update A person being updated 
    * @param incoming An incoming person created from message
    * @param info encapsulates verification information 
    * @throws ServiceException
    */
   public Person processVBAData( Person incoming, VAFacility sendingFacility, Person updated, VerificationInfo info ) throws ServiceException;
   
   /** Extracts enrollment verfication information from a verification
    * information oject to decide whether or not VBA data can be accepted
    * to prepare the data for an enrollment process to verify a person's eligibility status
    *
    * @param update A person being updated 
    * @param info encapsulates verification information 
    * @param incoming An incoming person created from message
    * @throws ServiceException
    */
   public Person verifyEligibility( Person incoming, Person updated, VerificationInfo info ) throws ServiceException;
}
