/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.service;

//Java classes
import java.io.Serializable;

// Library classes

// Framework classes
import gov.va.med.fw.service.ServiceException;

// EDB classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public interface POWRuleService extends Serializable {

   /**
    * @param pow
    * @param onFile
    * @throws ServiceException
    */
   public void processPOW( Person incoming, Person onFile ) throws ServiceException;
   
   /**
    * @param pow
    * @param onFile
    * @param sendingFacility
    * @throws ServiceException
    */
   public void processPOW( Person incoming, Person onFile,VAFacility sendingFacility) throws ServiceException;
   
   /**
    * 
    * @param incoming
    * @param onFile
    * @throws ServiceException
    */
   public void managePOW( Person incoming, Person onFile ) throws ServiceException;   
}
