/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
// Package
package gov.va.med.esr.common.rule.service;

// Java classes
import gov.va.med.esr.common.model.ee.Activation;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.CampLejeuneVerificationMethod;
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.Deployment;
import gov.va.med.esr.common.model.ee.EGTProcessStatistic;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.EGTSiteStatistic;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.EnrollmentOverride;
import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.ee.HealthBenefitProfile;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.MedalOfHonor;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.MilitarySexualTrauma;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.ReceivedEligibility;
import gov.va.med.esr.common.model.ee.ReceivedEnrollment;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.EmergencyResponseIndicator;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.HealthCareProvider;
import gov.va.med.esr.common.model.person.PatientProviderAssignmentLite;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSchedule;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;


import gov.va.med.fw.conversion.CopyServiceException;
import gov.va.med.fw.service.ServiceException;

import java.io.Serializable;
import java.util.Set;

/**
 * Provides methods to handle merge logics. A concrete implementation </br> of
 * this service could use ILOG JRule to implement business rule logics to merge
 * 2 busines entities. Project: Common</br> Created on: 4:07:45 PM </br>
 *
 * @author DNS   LEV
 */
public interface MergeRuleService extends Serializable {

	public Employment mergeEmployment(Employment incoming, Employment onFile)
			throws ServiceException;

	public void mergeEmployment(Person incoming, Person onFile)
			throws ServiceException;

	public void mergePhone(Person incoming, Person onFile)
			throws ServiceException;

	public void mergeEmail(Person incoming, Person onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public MonetaryBenefit mergeMonetaryBenefit(MonetaryBenefit incoming,
			MonetaryBenefit onFile) throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public IneligibilityFactor mergeIneligibilityFactor(
			IneligibilityFactor incoming, Person onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public EligibilityVerification mergeEligibilityVerification(
			EligibilityVerification incoming, EligibilityVerification onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public EligibilityVerification mergeEligibilityVerification(
			EligibilityVerification incoming, Person onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public MedicaidFactor mergeMedicaidFactor(MedicaidFactor incoming,
			MedicaidFactor onFile) throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public CancelDecline mergeCancelDecline(CancelDecline incoming,
			CancelDecline onFile) throws ServiceException;

	/**
	 * Merge the cancel decline data from person.
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public CancelDecline mergeCancelDecline(CancelDecline incoming,
			Person onFile) throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public Application mergeApplication(Application incoming, Application onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public MonetaryBenefitAward mergeMonetaryBenefitAward(
			MonetaryBenefitAward incoming, MonetaryBenefitAward onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public MonetaryBenefitAward mergeMonetaryBenefitAward(
			MonetaryBenefitAward incoming, Person onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public ServiceConnectionAward mergeServiceConnectionAward(
			ServiceConnectionAward incoming, ServiceConnectionAward onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public ServiceConnectionAward mergeServiceConnectionAward(
			ServiceConnectionAward incoming, Person onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public IncompetenceRuling mergeIncompetenceRuling(
			IncompetenceRuling incoming, IncompetenceRuling onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public IncompetenceRuling mergeIncompetenceRuling(
			IncompetenceRuling incoming, Person onFile) throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public InsurancePolicy mergeInsuranceAddress(Address incoming,
			InsurancePolicy onFile) throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public InsurancePolicy mergeInsurancePolicy(InsurancePolicy incoming,
			InsurancePolicy onFile) throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public InsurancePolicy mergeInsurancePolicy(InsurancePolicy incoming,
			Person onFile) throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public Association mergeAssociation(Association incoming, Person onFile)
			throws ServiceException;

	/**
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public Association mergeAssociation(Association incoming, Association onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public Address mergeAddress(Address incoming, Address onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public Phone mergePhone(Phone incoming, Person onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public Phone mergePhone(Phone incoming, Phone onFile)
			throws ServiceException;

	/**
	 * Merges the Military Service graph of objects without deleting anything.
	 * Targeted for use in MSDS processing.
	 *
	 * @param incoming
	 * @param onFile
	 * @throws ServiceException
	 */
	public void mergeMilitaryServiceNoDeletes(Person incoming, Person onFile)
			throws ServiceException;

	/**
	 * Merges the MilitaryServiceSiteRecord objects.
	 *
	 * @param incoming
	 *            the incoming MilitaryServiceSiteRecord
	 * @param onFile
	 *            the MilitaryServiceSiteRecord on file
	 */
	public void mergeMilitaryServiceSiteRecord(
			MilitaryServiceSiteRecord incoming, MilitaryServiceSiteRecord onFile);

	/**
	 * Merges the MilitaryServiceEpisode objects.
	 *
	 * @param incoming
	 *            the incoming MilitaryServiceEpisode
	 * @param onFile
	 *            the MilitaryServiceEpisode on file
	 * @return MilitaryServiceEpisode on file after merging.
	 * @throws ServiceException
	 */
	public MilitaryServiceEpisode mergeMilitaryServiceEpisode(
			MilitaryServiceEpisode incoming, MilitaryServiceEpisode onFile)
			throws ServiceException;

	/**
	 * Merges the CombatEpisode objects.
	 *
	 * @param incoming
	 *            the incoming CombatEpisode
	 * @param onFile
	 *            the CombatEpisode on file
	 * @return CombatEpisode on file after merging.
	 * @throws ServiceException
	 */
	public CombatEpisode mergeCombatEpisode(CombatEpisode incoming,
			CombatEpisode onFile);

	/**
	 * Merges the CombatService.
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 */
	public CombatService mergeCombatService(CombatService incoming,
			CombatService onFile);

	/**
	 * Merges the ConflictExperience objects.
	 *
	 * @param incoming
	 *            the incoming ConflictExperience
	 * @param onFile
	 *            the ConflictExperience on file
	 * @return ConflictExperience on file after merging.
	 * @throws ServiceException
	 */
	public ConflictExperience mergeConflictExperience(
			ConflictExperience incoming, ConflictExperience onFile)
			throws ServiceException;

	/**
	 * Merges the incoming purple heart to the result purple heart.
	 *
	 * @param incoming
	 *            the incoming purple heart
	 * @param result
	 *            the result purple heart
	 * @return result purple heart after merging
	 * @throws ServiceException
	 */
	public PurpleHeart mergePurpleHeart(PurpleHeart incoming, PurpleHeart result)
			throws ServiceException;

	/**
	 * Merges the incoming Medal Of Honor with result
	 *
	 * @param incoming
	 * @param result
	 * @return
	 * @throws ServiceException
	 */
	public MedalOfHonor mergeMedalOfHonor(MedalOfHonor incoming,
			MedalOfHonor result) throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public Email mergeEmail(Email incoming, Person onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public Email mergeEmail(Email incoming, Email onFile)
			throws ServiceException;

	/**
	 * @param incoming
	 *            SpecialFactor
	 * @param onFile
	 *            SpecialFactor
	 * @return
	 * @throws ServiceException
	 */
	public SpecialFactor mergeSpecialFactor(SpecialFactor incoming,
			SpecialFactor onFile) throws ServiceException;

	/**
	 *
	 * @param incoming
	 *            SpecialFactor
	 * @param onFile
	 *            Person
	 * @return
	 * @throws ServiceException
	 */
	public SpecialFactor mergeSpecialFactor(SpecialFactor incoming,
			Person onFile) throws ServiceException;

	/**
	 * Merge special factors from a person.
	 *
	 * @param incoming
	 * @param onFile
	 * @throws ServiceException
	 */
	public void mergeSpecialFactor(Person incoming, Person onFile)
			throws ServiceException;

	/**
	 * Merges the CatastrophicDisability objects.
	 *
	 * @param source
	 *            the incoming CatastrophicDisability
	 * @param target
	 *            the CatastrophicDisability on file
	 * @return CatastrophicDisability on file after merging.
	 * @throws ServiceException
	 */
	public CatastrophicDisability mergeCatastrophicDisability(
			CatastrophicDisability source, CatastrophicDisability target)
			throws ServiceException;

	/**
	 * Merges the CatastrophicDisability objects.
	 *
	 * @param source
	 *            the incoming CatastrophicDisability
	 * @param target
	 *            the CatastrophicDisability on file
	 * @param isFromUI
	 *            the data is from UI if TRUE otherwise other source such as messaging
	 * @return CatastrophicDisability on file after merging.
	 * @throws ServiceException
	 */
	public CatastrophicDisability mergeCatastrophicDisability(
			CatastrophicDisability source, CatastrophicDisability target, boolean isFromUI)
			throws ServiceException;


	/**
	 * Merges the CatastrophicDisability's CDDescriptor objects ONLY. Leaves intact
	 * existing conditions/procedures/diagnoses. Does not update CD attributes.
	 *
	 * @param source
	 *            the incoming CatastrophicDisability
	 * @param target
	 *            the CatastrophicDisability on file
	 * @param addOnly
	 * 			  only adding only of CDDescriptors
	 * @return CatastrophicDisability on file after merging.
	 * @throws ServiceException
	 */
	public CatastrophicDisability mergeCatastrophicDisabilityCDDescriptorsOnly(
			CatastrophicDisability source, CatastrophicDisability target, boolean addOnly)
			throws ServiceException;

	/**
	 * Merges the MilitarySexualTrauma objects.
	 *
	 * @param source
	 *            the incoming MilitarySexualTrauma
	 * @param target
	 *            the MilitarySexualTrauma on file
	 * @return MilitarySexualTrauma on file after merging.
	 * @throws ServiceException
	 */
	public MilitarySexualTrauma mergeMilitarySexualTrauma(
			MilitarySexualTrauma source, MilitarySexualTrauma target)
			throws ServiceException;

	/**
	 * Merges the NoseThroatRadium objects.
	 *
	 * @param source
	 *            the incoming NoseThroatRadium
	 * @param target
	 *            the NoseThroatRadium on file
	 * @return NoseThroatRadium on file after merging.
	 * @throws ServiceException
	 */
	public NoseThroatRadium mergeNoseThroatRadium(NoseThroatRadium source,
			NoseThroatRadium target) throws ServiceException;

	/**
	 * Merges the demographic information in incoming person to the person on
	 * file.
	 *
	 * @param incoming
	 *            the incoming person
	 * @param onFile
	 *            the person on file
	 * @return person on file after merging.
	 * @throws ServiceException
	 */
	public Person mergeDemographic(Person incoming, Person onFile)
			throws ServiceException;

	/**
	 * Merge the identity traits info from incoming person to on-file person
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public Person mergeIdentityTraits(Person incoming, Person onFile)
			throws ServiceException;

	/**
	 * Merges the death record.
	 *
	 * @param incoming
	 *            the incoming death record
	 * @param onFile
	 *            the on file death record
	 * @return the updated on file death record
	 * @throws ServiceException
	 */
	public DeathRecord mergeDeathRecord(DeathRecord incoming, DeathRecord onFile)
			throws ServiceException;

	/**
	 * Merges the FinancialStatement Objects
	 *
	 * @param incoming
	 * @param onFile
	 * @return FinancialStatement
	 * @throws ServiceException
	 */
	public FinancialStatement mergeFinancialStatement(
			FinancialStatement incoming, FinancialStatement onFile)
			throws ServiceException;

	public FinancialStatement mergeFinancialStatement(
			FinancialStatement incoming, FinancialStatement onFile,
			boolean isMergeForZ07) throws ServiceException;

	/**
	 * Merges the FinancialInformation Objects. This includes merging of income,
	 * asset and expense maps.
	 *
	 * @param incoming
	 * @param onFile
	 * @return FinancialStatement
	 * @throws ServiceException
	 */
	public FinancialInformation mergeFinancialInformation(
			FinancialInformation incoming, FinancialInformation onFile)
			throws ServiceException;

	/**
	 * Merge the full income test. This includes all the properties that are
	 * excluded in the commons.xml excluding person.
	 *
	 * @param incomingTest
	 * @param resultTest
	 * @throws ServiceException
	 */
	public void mergeFullIncomeTest(IncomeTest incomingTest,
			IncomeTest resultTest) throws ServiceException;

	/**
	 * Merges the IncomeTest Objects
	 *
	 * @param incoming
	 * @param onFile
	 * @return IncomeTest
	 * @throws ServiceException
	 */
	public IncomeTest mergeIncomeTest(IncomeTest incoming, IncomeTest onFile)
			throws ServiceException;

	/**
	 * Merges the IncomeTestStatus Objects
	 *
	 * @param incomingStatus
	 * @param targetStatus
	 * @throws CopyServiceException
	 */
	public void mergeIncomeTestStatus(IncomeTestStatus incomingStatus,
			IncomeTestStatus targetStatus) throws CopyServiceException;

	/**
	 * Merges the SpouseFinancials Objects
	 *
	 * @param incoming
	 * @param onFile
	 * @return SpouseFinancials
	 * @throws ServiceException
	 */
	public SpouseFinancials mergeSpouseFinancials(SpouseFinancials incoming,
			SpouseFinancials onFile) throws ServiceException;

	/**
	 * Merges the DependentFinancials Objects
	 *
	 * @param incoming
	 * @param onFile
	 * @return DependentFinancials
	 * @throws ServiceException
	 */
	public DependentFinancials mergeDependentFinancials(
			DependentFinancials incoming, DependentFinancials onFile)
			throws ServiceException;

	/**
	 * Merges the Spouse Objects
	 *
	 * @param incoming
	 * @param onFile
	 * @return Spouse
	 * @throws ServiceException
	 */
	public Spouse mergeSpouse(Spouse incoming, Spouse onFile)
			throws ServiceException;

	/**
	 * Merges the Dependent Objects
	 *
	 * @param incoming
	 * @param onFile
	 * @return Dependent
	 * @throws ServiceException
	 */
	public Dependent mergeDependent(Dependent incoming, Dependent onFile)
			throws ServiceException;

	/**
	 * Merge the Deployment.
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public Deployment mergeDeployment(Deployment incoming, Deployment onFile)
			throws ServiceException;

	public Activation mergeActivation(Activation incoming, Activation onFile)
			throws ServiceException;

	public void mergeSSN(Relation incoming, Relation onFile)
			throws ServiceException;

	/**
	 * Merges the PatientVisitSummary Objects
	 *
	 * @param incoming
	 * @param onFile
	 * @return PatientVisitSummary
	 * @throws ServiceException
	 */
	public PatientVisitSummary mergePatientVisitSummary(
			PatientVisitSummary incoming, PatientVisitSummary onFile)
			throws ServiceException;

	/**
	 * Merges the BeneficiaryTravel Objects
	 *
	 * @param incoming
	 * @param onFile
	 * @return BeneficiaryTravel
	 * @throws ServiceException
	 */
	public BeneficiaryTravel mergeBeneficiaryTravel(BeneficiaryTravel incoming,
			BeneficiaryTravel onFile) throws ServiceException;

	/**
	 * Merges the FeeBasis Objects
	 *
	 * @param incoming
	 * @param onFile
	 * @return FeeBasis
	 * @throws ServiceException
	 */
	public FeeBasis mergeFeeBasis(FeeBasis incoming, FeeBasis onFile)
			throws ServiceException;

	/**
	 * Merges the Hardship Objects
	 *
	 * @param incoming
	 * @param onFile
	 * @return Hardship
	 * @throws ServiceException
	 */
	public Hardship mergeHardship(Hardship incoming, Hardship onFile)
			throws ServiceException;

	/**
	 * Merges the Received Enrollment objects
	 *
	 * @param incoming
	 * @param onFile
	 * @return Dependent
	 * @throws ServiceException
	 */
	public ReceivedEnrollment mergeReceivedEnrollment(
			ReceivedEnrollment incoming, ReceivedEnrollment onFile)
			throws ServiceException;

	/**
	 * Merges the received eligibility
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public ReceivedEligibility mergeReceivedEligibility(
			ReceivedEligibility incoming, ReceivedEligibility onFile)
			throws ServiceException;

	/**
	 * Merges the enrollment override
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 */
	public EnrollmentOverride mergeEnrollmentOverride(
			EnrollmentOverride incoming, EnrollmentOverride onFile)
			throws ServiceException;

	/**
	 * Merge enrollment determination
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public EnrollmentDetermination mergeEnrollmentDetermination(
			EnrollmentDetermination incoming, EnrollmentDetermination onFile)
			throws ServiceException;

	public Eligibility mergeEligibility(Eligibility incoming, Eligibility onFile)
			throws ServiceException;

	/**
	 * Merge the PrisonerOfWar
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public PrisonerOfWar mergePrisonerOfWar(PrisonerOfWar incoming,
			PrisonerOfWar onFile) throws ServiceException;

	/**
	 * Merge the PrisonerOfWar
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public PrisonerOfWar mergePrisonerOfWar(PrisonerOfWar incoming,
			Person onFile) throws ServiceException;

	public POWEpisode mergePOWEpisode(POWEpisode incoming, POWEpisode onFile)
			throws ServiceException;

	/**
	 * Merge the SignatureImage
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public SignatureImage mergeSignatureImage(SignatureImage incoming,
			SignatureImage onFile) throws ServiceException;

	/**
	 * Merge the SignatureImage with person
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public SignatureImage mergeSignatureImage(SignatureImage incoming,
			Person onFile) throws ServiceException;

	/**
	 * Merges PurpleHeart registrie.
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public PurpleHeart mergeRegistry(PurpleHeart incoming, PurpleHeart onFile)
			throws ServiceException;

	public PurpleHeart mergeRegistry(PurpleHeart incoming, PurpleHeart onFile,
			boolean isUI) throws ServiceException;

	/**
	 * Merges PrisonerOfWar registriy.
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public PrisonerOfWar mergeRegistry(PrisonerOfWar incoming,
			PrisonerOfWar onFile) throws ServiceException;

	public PrisonerOfWar mergeRegistry(PrisonerOfWar incoming,
			PrisonerOfWar onFile, boolean isUI) throws ServiceException;

	/**
	 * Merges SHAD registry.
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public SHAD mergeRegistry(SHAD incoming, SHAD onFile)
			throws ServiceException;

	public SHAD mergeRegistry(SHAD incoming, SHAD onFile, boolean isUI)
			throws ServiceException;

	/**
	 * Merge all of the person's data.
	 *
	 * @param incoming
	 * @param onFile
	 * @param isUpdateFromGUI
	 * @return
	 * @throws ServiceException
	 */
	public Person mergePerson(Person incoming, Person onFile,
			boolean isUpdateFromGUI) throws ServiceException;

	/**
	 * Merge person's EmergencyResponseIndicators.
	 *
	 * @param incoming
	 * @param onFile
	 * @throws ServiceException
	 */
	public void mergeEmergencyResponseIndicator(Person incoming, Person onFile)
			throws ServiceException;

	/**
	 * Merge EmergencyResponseIndicator.
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public EmergencyResponseIndicator mergeEmergencyResponseIndicator(
			EmergencyResponseIndicator incoming,
			EmergencyResponseIndicator onFile) throws ServiceException;

	/**
	 * Merge EGTSetting.
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public EGTSetting mergeEGTSetting(EGTSetting incoming, EGTSetting onFile)
			throws ServiceException;

	/**
	 * Merge EGTProcessStatistic
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public EGTProcessStatistic mergeEGTProcessStatistic(
			EGTProcessStatistic incoming, EGTProcessStatistic onFile)
			throws ServiceException;

	/**
	 * Merge EGTSiteStatistic
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public EGTSiteStatistic mergeEGTSiteStatistic(EGTSiteStatistic incoming,
			EGTSiteStatistic onFile) throws ServiceException;

	/**
	 * Merge the Sets from incoming (source) to onFile (destination) and return
	 * resultant Set. Any duplicate items in the incoming set (duplicate in the
	 * sense that two items are considered equal given the matchService's
	 * "domain concepts") are only added ONCE to the resultant Set. If duplicate
	 * items should be retained, call mergeSets(Set, Set, boolean), and pass
	 * true for the last arg.
	 * <p>
	 * This method is used to merge CDCondition/CDDiagnosis/CDProcedure sets and
	 * many others.
	 */
	public Set mergeSets(Set incoming, Set onFile) throws ServiceException;

	/**
	 * Merge the Sets from incoming (source) to onFile (destination) and return
	 * resultant Set. Any duplicate items in the incoming set (duplicate in the
	 * sense that two items are considered equal given the matchService's
	 * "domain concepts") are ALL added to the resultant Set. If duplicate items
	 * should be removed, call mergeSets(Set, Set) or pass false for the last
	 * arg.
	 * <p>
	 * This method is only used when merging RatedDisabilities as of 11/2010.
	 */
	public Set mergeSets(Set incoming, Set onFile,
			boolean alwaysAddIncomingDuplicates) throws ServiceException;

	/**
	 * @return
	 */
	public MatchRuleService getMatchRuleService();

	/**
	 * This method merges ReportSetup.
	 *
	 * @param incoming
	 * @param onFile
	 * @throws ServiceException
	 */
	public void mergeReportSetup(ReportSetup incoming, ReportSetup onFile)
			throws ServiceException;

	/**
	 * This method merges ReportParameterSet
	 *
	 * @param incoming
	 * @param onFile
	 * @throws ServiceException
	 */
	public void mergeReportParameterSet(ReportParameterSet incoming,
			ReportParameterSet onFile) throws ServiceException;

	/**
	 * This method merges ReportSchedule.
	 *
	 * @param incoming
	 * @param onFile
	 * @throws ServiceException
	 */
	public void mergeReportSchedule(ReportSchedule incoming,
			ReportSchedule onFile) throws ServiceException;

	/**
	 * Merge the received eligibilities
	 *
	 * @param incoming
	 * @param onFile
	 * @throws ServiceException
	 */
	public void mergeReceivedEligibility(Person incoming, Person onFile)
			throws ServiceException;

	/**
	 * Merge user account information
	 *
	 * @param incoming
	 * @param onFile
	 * @throws ServiceException
	 */
	public void mergeUserAccount(ESRUserPrincipalImpl incoming,
			ESRUserPrincipalImpl onFile) throws ServiceException;

	/**
	 * Merge user profile information
	 *
	 * @param incoming
	 * @param onFile
	 * @throws ServiceException
	 */
	public void mergeUserProfile(ESRUserPrincipalImpl incoming,
			ESRUserPrincipalImpl onFile) throws ServiceException;

	/**
	 * Merge SHAD data.
	 *
	 * @param incoming
	 * @param onFile
	 * @return
	 * @throws ServiceException
	 */
	public SHAD mergeSHAD(SHAD incoming, Person onFile) throws ServiceException;

	/**
	 * Merges the Spouse Emplyment
	 *
	 * @param incoming
	 * @param onFile
	 * @return Spouse
	 * @throws ServiceException
	 */
	public void mergeSpouseEmployment(Spouse incoming, Spouse onFile)
			throws ServiceException;

	/**
	 * Merges the Spouse Address
	 *
	 * @param incoming
	 * @param onFile
	 * @throws ServiceException
	 */
	public void mergeSpouseAddress(Spouse incoming, Spouse onFile)
			throws ServiceException;

	/**
	 * Merges the Spouse Home Phone
	 *
	 * @param incoming
	 * @param onFile
	 * @throws ServiceException
	 */
	public void mergeSpouseHomePhone(Spouse incoming, Spouse onFile)
			throws ServiceException;

	/**
	 * Merges a single MilitaryServiceEpisodes objects based on Seeding rules.
	 *
	 * @param incoming
	 *            the incoming MilitaryServiceEpisode
	 * @param onFile
	 *            the HECMilitaryServiceSiteRecord on file
	 */
	public void mergeSeedingMilitaryServiceEpisode(
			MilitaryServiceEpisode incomingEpisode,
			MilitaryServiceEpisode overlappedEpisode,
			MilitaryServiceSiteRecord onFile);

	public Set mergeRatedDisabilities(Set incomingDisabilities,
			Set onFileDisabilities) throws ServiceException;

	public Set mergeRatedDisabilitiesFromHL7(Set incomingDisabilities,
			Set onFileDisabilities) throws ServiceException;

	public void mergeIncomingMSEToHEC(MilitaryServiceSiteRecord incoming,
			MilitaryServiceSiteRecord onFile);

	public void mergeHealthCareProvider(HealthCareProvider incoming, HealthCareProvider onFile) throws ServiceException;

	public void mergeProviderAssignment(PatientProviderAssignmentLite incoming, PatientProviderAssignmentLite onFile) throws ServiceException;

	public void mergeHealthBenefitProfile(HealthBenefitProfile incoming, HealthBenefitProfile onFile) throws ServiceException;

	public void mergeCampLejeuneVerification(CampLejeuneVerification incoming, CampLejeuneVerification onFile) throws ServiceException;

	public void mergeCLVerificationMethod(CampLejeuneVerificationMethod incoming, CampLejeuneVerificationMethod onFile) throws ServiceException;

	public void mergeFinancialData(Person incoming, Person onFile) throws ServiceException;


}