/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.rule.service;

// Java classes
import java.io.Serializable;
import java.util.Collection;

// Library classes

// Framework classes
import gov.va.med.fw.model.AbstractEntity;

// ESR classes

/**
 * Encapsulates how 2 business entities in the ESR application are 
 * determined to be equal using business rules.
 *
 * Project: Common</br>
 * Created on: 2:20:12 PM </br>
 *
 * @author DNS   LEV
 */
public interface MatchRuleService extends Serializable {
	
	/** Compares 2 entities for equality.  The comparison is
	 * based on significant business attributes in the derived entity classes.
	 * 
	 * @param source A source to compare
	 * @param target A target to compare
	 * @return True if equal False otherwise
	 */
	public boolean match( AbstractEntity source, AbstractEntity target );

	/** Finds a matching element in a collection to return.
	 * 
	 * @param source A source to look for a match
	 * @param target A collection to look for a match
	 * @return AbstractEntity a match
	 */
	public AbstractEntity findMatchingElement( AbstractEntity source, Collection target );
}