/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.service;

//Java classes
import java.io.Serializable;
import java.util.Set;

// Library classes

// Framework classes
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessages;

// EDB classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public interface InsuranceRuleService extends Serializable {
    
    /**
     * 
     * @param medicaidFactor
     * @param onFile
     * @throws ServiceException
     */
    public void processMedicaidFactor( MedicaidFactor medicaidFactor, Person onFile ) throws ServiceException;

    /**
     * 
     * @param medicaidFactor
     * @param onFile
     * @throws ServiceException
     */
    public void manageMedicaidFactor( MedicaidFactor medicaidFactor, Person onFile ) throws ServiceException;
    
    /**
     * Processes a collection of insurance policies.  There are 3 types of insurance policies
     * <br>in the ESR application: Medicaid, Medicare, and Private Insurance
     *     	
     * @param policies A collection of insurance policies
     * @param onFile A person currently stored in the system
     * @param sendingFacility site making the updates(HEC for the UI)
     * @throws ServiceException In case of error in processing insurance data
     */
    public ValidationMessages manageInsurancePolicies( Set policies, Person onFile, VAFacility sendingFacility ) throws ServiceException;
    
    /** 
     * Processes a collection of insurance policies.  There are 3 types of insurance policies
     * <br>in the ESR application: Medicaid, Medicare, and Private Insurance. This method
     * is called only by Messaging.  In Messaging, we need to process all policies that
     * come in from an HL7 message while in UI we only need to process what is new or updated.
     *     	
     * @param policies A collection of insurance policies
     * @param onFile A person currently stored in the system
     * @param sendingFacility site sending the message
     * @throws ServiceException In case of error in processing insurance data
     */
    public void processInsurancePolicies( Set policies, Person onFile, VAFacility sendingFacility ) throws ServiceException;
    
    public void postProcessVOASubmissions(Set policies, Person onFile,VAFacility sendingFacility) throws ServiceException;
}