package gov.va.med.esr.common.rule.service;

// Java classes
import java.io.Serializable;

// Library classes

// Framework classes
import gov.va.med.fw.service.ServiceException;

// ESR classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.ee.IncomingMessageInfo;
import gov.va.med.esr.common.model.ee.VerificationInfo; 

/**
 * Project: Common
 * @author DNS   RUIZC
 * @version 1.0
 */
public interface EventRuleService extends Serializable {
    /**
     * A method to process message events for UI or message processing.
     * 
     * @param onFile
     * @throws ServiceException
     */
    public void processMessageEvents(Person onFile)  throws ServiceException;
    
    public void processMessageEventsForIVM(Person onFile)  throws ServiceException;    

    /**
     * Process events dealing with sending messages for a query request
     * 
     * @param onFile
     * @param incomeYear
     * @param incomingMessageInfo
     * @param verificationInfo
     * @throws ServiceException
     */
    public void processMessageEvents(Person onFile, Integer incomeYear,
            IncomingMessageInfo incomingMessageInfo,
            VerificationInfo verificationInfo) throws ServiceException;        
    
    /**
     * Process message events for Z12/Z13 messages
     * 
     * @param person
     * @param verificationInfo
     * @param  isZ10Sent
     * @throws ServiceException
     */
    public void processMessageEvents(Person person, VAFacility sendingFacility, VerificationInfo verificationInfo,  boolean isZ10Sent)
            throws ServiceException; //added sendingFacility is isMessageFromVoa can work correctly
    
    /**
     * Process message events for Z12/Z13 messages
     * 
     * @param person
     * @param verificationInfo
     * @param  isZ10Sent
     * * @param fromAddNewPerson
     * @throws ServiceException
     */
    public void processMessageEvents(Person person, VerificationInfo verificationInfo,  boolean isZ10Sent,boolean fromAddNewPerson)
            throws ServiceException;
    
    
    /**
     * Process message events for trigger broker messages
     * 
     * @param person
     * @param isMSDSTrigger     * 
     * @throws ServiceException
     */
    public void processMessageEvents(Person onFile, boolean isMSDSTrigger)
    	throws ServiceException;


    /**
     * 
     * @param person
     * @param verificationInfo
     * @throws ServiceException
     */
    public void processMessageEvents(Person person, VerificationInfo verificationInfo) throws ServiceException;    
    
    /**
     * A method to process message events after UI data processing.
     * 
     * @param onFile
     * @throws ServiceException
     */
    public void manageMessageEvents(Person onFile)  throws ServiceException;    
    
    /**
     * A method to process person related events from a message such as changes in
     * SC percent.
     * 
     * @param onFile
     * @throws ServiceException
     */
    public void processPersonEvents(Person onFile) throws ServiceException;
    
    /**
     * Convenience method for use by Appointment Conversion batch process
     * 
     * @param onFile
     * @throws ServiceException
     */
    public void processPersonEventsForAppointmentConversion(Person onFile) throws ServiceException;    
    
    /**
     * A method to process person related events from UI such as changes in
     * SC percent.
     *  
     * @param onFile
     * @throws ServiceException
     */
    public void managePersonEvents(Person onFile) throws ServiceException;    
    
    /**
     * Convenience method to handle common post events. These are events
     * due to changes in E&E results or other person data.
     *  
     * @param onFile
     * @param isDataFromUI
     * @throws ServiceException
     */
    public void handleCommonPostEvents(Person onFile, boolean isDataFromUI) throws ServiceException;
    
    /**
     * Same convenience method as above but also includes flag for indicating if Z10 was sent by prior
     * rule flow. This is only necessary when a  rule flow triggers a Z10. Such a flow needs to return
     * a flag to caller, who should then forward the flag to this method.
     * 
     * @param onFile
     * @param isDataFromUI
     * @param isZ10Sent
     * @throws ServiceException
     */
    public void handleCommonPostEvents(Person onFile, boolean isDataFromUI, boolean isZ10Sent) throws ServiceException;  
    
    /**
     * Convenience method to handle handbook events. These are events
     * due to changes in E&E results or other person data.
     *  
     * @param onFile
     * @param isDataFromUI
     * @throws ServiceException
     */
    public void manageHandBookEvents(Person onFile) throws ServiceException;
    
    public void processPersonEventsForPensionBulletin(Person onFile) throws ServiceException;
    
    public void triggerCreateHecRecord(Person person) throws ServiceException;
    
    public void processMessageEventsForMsds(Person onFile)  throws ServiceException;
    
    public void addPersonChangeEventsForAdvice(Person person) throws ServiceException;
    
    public void postProcessVOASubmissions(Person onFile) throws ServiceException;
}
