/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.service;

// Java classes
import java.io.Serializable;

// Library classes


// Framework classes
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationServiceException;

// EDB classes
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnrollmentOverride;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.EEResultInfo;


/**
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public interface EligibilityFactorRuleService extends Serializable {

   /**
    * @param sc
    * @param onFile
    * @throws ServiceException
    */
   public void processServiceConnectionAward( ServiceConnectionAward sc, Person onFile ) throws ServiceException;
   /**
    * @param mb
    * @param onFile
    * @throws ServiceException
    */
   public void processMonetaryBenefitAward( MonetaryBenefitAward mb, Person onFile ) throws ServiceException;

   /**
    * @param mb
    * @param onFile
    * @throws ServiceException
    */
   public void manageMonetaryBenefitAward( MonetaryBenefitAward mb, Person onFile ) throws ServiceException;

   /**
    * Process the special factors from a message that are contained in person.
    *
    * @param incoming Person
    * @param onFile Person
    * @throws ServiceException
    */
   public void processSpecialFactors( Person incoming, VAFacility sendingFacility, Person onFile,boolean isUpdateFromGUI ) throws ServiceException;

   /**
    * Process special factors.
    *
    * @param incoming Person
    * @param sendingFacility the sending facility
    * @param onFile Person
    * @param clvInfo Camp Lejeune info
    * @throws ServiceException
    */
   public void processSpecialFactors( Person incoming, VAFacility sendingFacility, Person onFile,boolean isUpdateFromGUI, EEResultInfo clvInfo ) throws ServiceException;

   /**
    * Process the special factors from UI that are contained in person.
    *
    * @param incoming Person
    * @param onFile Person
    * @throws ServiceException
    */
   public void manageSpecialFactors( Person incoming, Person onFile ) throws ServiceException;

   /**
    *
    * @param incoming
    * @param onFile
    * @throws ServiceException
    */
   public void processIncompetenceRuling( IncompetenceRuling incoming, Person onFile ) throws ServiceException;

   /**
    * A method to process an eligibility verification object from Messaging
    *
    * @param incoming
    * @param onFile
    * @throws ServiceException
    */
   public void processEligibilityVerification(
            EligibilityVerification incoming, Person onFile)
            throws ServiceException;

   /**
    * A method to process an eligibility verification object from UI
    *
    * @param incoming
    * @param onFile
    * @throws ServiceException
    */
   public void manageEligibilityVerification(
           EligibilityVerification incoming, Person onFile)
           throws ServiceException;

   /**
    * A method to process a new veteran to ESR.
    *
    * @param incoming
    * @param onFile
    * @throws ServiceException
    */
   public void processNewVeteran(Person incoming, Person onFile) throws ServiceException;

   /**
    * CCR 10892 Add a Person
    * A method to process a new veteran from Add a Person UI.
    *
    * @param incoming
    * @param onFile
    * @throws ServiceException
    */
   public void manageNewVeteranFromAddPerson(Person incoming, Person onFile) throws ServiceException;

   /**
    *
    * @param incoming
    * @param onFile
    * @throws ServiceException
    */
   public void manageEnrollmentOverride(EnrollmentOverride incoming, Person onFile) throws ServiceException;

   /**
    * Method to process person's  EmergencyResponseIndicators.
    *
    * @param incoming
    * @param onFile
    * @throws ServiceException
    */
   public void processEmergencyResponseIndicator(Person incoming, Person onFile) throws ServiceException;

   /**
    * Validation method for UI to call
    *
    * @param incomingMBA
    * @param onFile
    * @throws ValidationServiceException
    */
   public void validateMonetaryBenefit(MonetaryBenefitAward incomingMBA, Person onFile) throws ValidationServiceException;
}
