/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.service;

// Java classes
import java.io.Serializable;

// Library classes

// Framework classes
import gov.va.med.fw.service.ServiceException;

// EDB classes
import gov.va.med.esr.common.model.ee.EGTSetting;

/**
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public interface EGTRuleService extends Serializable {

   /**
    * Process the incoming EGTSetting and returned the processed 
    * EGT Setting Object.
    * 
    * @param incoming - EGTSetting Object to process.
    * @param onFile - EGTSetting Object on file.
    * @return EGTSetting
    * @throws ServiceException
    */
   public EGTSetting processEGT( EGTSetting incoming, EGTSetting onFile ) throws ServiceException;
   
   /**
    * Execute the manage EGT use case rules.
    * 
    * @param incoming
    * @param onFile
    * @return
    * @throws ServiceException
    */
   public EGTSetting manageEGT( EGTSetting incoming, EGTSetting onFile ) throws ServiceException;   
}

