/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.service;

// Java classes
import java.io.Serializable;
import java.util.Set;
import java.util.Date;

import gov.va.med.fw.service.ServiceException;

import gov.va.med.esr.common.batchprocess.SSASSNVerificationData;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.ee.VerificationInfo;

/**
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public interface DemographicRuleService extends Serializable {

    /**
     * Updates demographic information. This method is meant to be called from UI.
     * @param incoming person with the data updated by UI
     * @param onFile on-file person from the database
     * 
     * @throws ServiceException thrown when there is application error or rule validation errors.
     */
    public Person manageDemographicInfo(Person incoming, Person onFile) throws ServiceException;
    
    /**
     * Updates demographic information. This method is meant to be called from the Messaging.
     * @param incoming person with the data updated by Messaging.
     * @param onFile the person on file
     * 
     * @throws ServiceException thrown when there is application error or rule validation errors.
     */
   public void processDemographicInfo(VAFacility sendingFacility, Person incoming, Person onFile, boolean isDataFromGUI, String MVIActiveInd) throws ServiceException;
   
   
   /**
    * Process the demographic information for an ORUZ12 or ORUZ13.
    * 
    * @param sendingFacility
    * @param incoming
    * @param onFile
    * @param verificationInfo
    * @throws ServiceException
    */
   public void processDemographicInfo(VAFacility sendingFacility, Person incoming, Person onFile, VerificationInfo verificationInfo) throws ServiceException;   

   
   /**
    * @param ssn
    * @param onFile
    * @throws ServiceException
    */
   public void processSocialSecurityInfo( SSN ssn, Person onFile ) throws ServiceException;
   
   /**
    * Manage the identity traits from the UI
    *  
    * @param incoming
    * @param onFile
    * @throws ServiceException
    */
   public void manageIdentityTraits(Person incoming, Person onFile) throws ServiceException;   

   /**
    * @param ssn
    * @param onFile
    * @throws ServiceException
    */
   public void processSocialSecurityInfo( Set ssn, Person onFile ) throws ServiceException;
   
   /**
    * Process the set of demographic change events from an EXTERNAL service.
    * 
    * @param changes
    * @param onFile
    * @throws ServiceException
    */
   public void processExternalDemographicChanges( Set changes, Person onFile ) throws ServiceException;   
   
   /**
    * Process the SSN Verification Response from SSA
    * 
    * @param incoming
    * @throws ServiceException
    */
    public void processSSNVerificationResponse(SSASSNVerificationData incoming, Person result, SSASSNVerificationData resultSSNVerificationData,Relation relation)
            throws ServiceException;
    /**
     * Attach a Death Record to the person using default values specific
     * to Idm context.
     * 
     * @param incoming
     * @param dateOfDeath
     * @throws ServiceException
     */
    public void attachDeathRecordFromIdm(Person incoming, Date dateOfDeath) throws ServiceException;    
    
    public void processDemographicInfo(VAFacility sendingFacility, Person incoming,
            Person onFile, boolean isDataFromGUI, boolean isDataFromMVI) throws ServiceException;
}
