/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.service;

// Java classes
import java.io.Serializable;
import java.util.Set;

import gov.va.med.fw.service.ServiceException;

import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;

/**
 * Provides methods to process business rules related to contact methods of a person. 
 * Phone, address, and electronic address are categorized as contact methods.  Each method in
 * this inteface takes 2 arguments.  The first argument is from the incoming record which is either 
 * from a screen or a message while the second one is from the current record in the system's database.  
 * <br>
 * <br>Project: Common
 * <br>
 * @author DNS   LEV
 * @version 1.0
 */
public interface ContactInfoRuleService extends Serializable {

    /**
     * Process addresses from a message.
     * 
     * @param incoming
     * @param onFile
     * @throws ServiceException
     */
    public void processAddresses(Set incoming, Person onFile, VAFacility sendingFacility)
            throws ServiceException; 
    
//  CCR11898
    /**
    * Process addresses from a message.
    * 
    * @param incoming
    * @param onFile
    * @param sendingFacility
    * @param verificationInfo
    * @throws ServiceException
    * */
     public void processAddresses(Set incoming, Person onFile, VAFacility sendingFacility, VerificationInfo verificationInfo)
    throws ServiceException; 



    /**
     * Process Electronic Addresses from a message.
     * 
     * @param emails
     * @param onFile
     * @throws ServiceException
     */
    public void processElectronicAddresses(Set emails, Person onFile, VAFacility sendingFacility)
            throws ServiceException;

    /**
     * Manage Electronic Addresses from a message.
     * 
     * @param emails
     * @param onFile
     * @throws ServiceException
     */
    public void manageElectronicAddresses(Set emails, Person onFile)
            throws ServiceException;

    /**
     * Process Phones from a message.
     * 
     * @param incoming
     * @param onFile
     * @throws ServiceException
     */
//  CCR12176 - change Set Phones to incoming person to check the ssn verfication status NEW from it
    public void processPhones(Person incoming, Person onFile,VAFacility sendingFacility)
            throws ServiceException;

    /**
     * Manages Phones from a message.
     * 
     * @param phones
     * @param onFile
     * @throws ServiceException
     */
    public void managePhones(Set phones, Person onFile)
            throws ServiceException;

    /**
     * Manage addresses from UI
     * 
     * @param incoming
     * @param onFile
     * @throws ServiceException
     */
    public void manageAddresses(Set incoming, Person onFile)
            throws ServiceException;

    /**
     * Manage address from UI
     * 
     * @param incoming
     * @param onFile
     * @throws ServiceException
     */
    public void manageAddress(Address incoming, Person onFile)
            throws ServiceException;
    
    /**
     * Manage addresses from UI that belong to association
     * 
     * @param incoming
     * @param onFile association
     * @throws ServiceException
     */
    public void manageAssociationAddresses(Set associations, Person onFile)
            throws ServiceException;

    /**
     * Manage address from UI that belongs to association
     * 
     * @param incoming
     * @param onFile association
     * @throws ServiceException
     */
    public void manageAssociationAddress(Association incoming, Person onFile)
            throws ServiceException;
    
    /**
     * Manage insurance addresses from UI 
     * 
     * @param policies A collection of insurance policy from an in-coming data
     * @param onFile A person on file
     * @throws ServiceException In case of errors processing insurance addresses
     */
    public void manageInsuranceAddresses(Set policies, Person onFile)
            throws ServiceException;

    /**
     * Manage addresses from UI that belong to insurance 
     * 
     * @param policy An insurance policy from an in-coming data
     * @param onFile A person on file
     * @throws ServiceException In case of errors processing insurance addresses
     */
    public void manageInsuranceAddress(InsurancePolicy policy, Person onFile)
            throws ServiceException;  
    public void manageHandBookForBadAddressText(Set incoming, Person onFile)
    	throws ServiceException ;
    	
    public void manageHandBookForBadAddressText(Address incoming, Person onFile) 
    		throws ServiceException;
    
    //CCR 11789: add fromAddNewPerson flag so if it is true, don't send MVI phone& address true.
    public void managePhones(Set phones, Person onFile, boolean fromAddNewPerson ) throws ServiceException ;
    
//  CCR 11789: add fromAddNewPerson flag so if it is true, don't send MVI phone& address true.
    public void manageAddresses(Set incoming, Person onFile, boolean fromAddNewPerson) throws ServiceException;
}